<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class VeterinaryEstablishmentServicePeriodResponseItem extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var string
     */
    protected $id;

    /**
     * @var \DateTime
     */
    protected $createdDate;

    /**
     * @var \DateTime
     */
    protected $updatedDate;

    /**
     * @var string|null
     */
    protected $accountingCode;

    /**
     * @var list<VeterinaryEstablishmentServicePeriodResponseItemAttributesItem>
     */
    protected $attributes;

    /**
     * @var int
     */
    protected $calculatedPriceWithoutVat;

    /**
     * @var int
     */
    protected $calculatedPriceWithVat;

    /**
     * @var \DateTime
     */
    protected $endDate;

    /**
     * @var string
     */
    protected $paymentMethod;

    /**
     * @var bool
     */
    protected $shouldGenerateInvoice;

    /**
     * Nullable Id - Response Model.
     *
     * @var NullableIdResponse|null
     */
    protected $specificBillingAccount;

    /**
     * Nullable Id - Response Model.
     *
     * @var NullableIdResponse|null
     */
    protected $specificVeterinaryGroup;

    /**
     * @var \DateTime
     */
    protected $startDate;

    /**
     * Id - Response Model.
     *
     * @var IdResponse
     */
    protected $veterinaryEstablishment;

    /**
     * Id - Response Model.
     *
     * @var IdResponse
     */
    protected $veterinaryEstablishmentServiceSubscription;

    /**
     * Id - Response Model.
     *
     * @var IdResponse
     */
    protected $veterinaryServiceOption;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getId(): string
    {
        return $this->id;
    }

    public function setId(string $id): self
    {
        $this->initialized['id'] = true;
        $this->id = $id;

        return $this;
    }

    public function getCreatedDate(): \DateTime
    {
        return $this->createdDate;
    }

    public function setCreatedDate(\DateTime $createdDate): self
    {
        $this->initialized['createdDate'] = true;
        $this->createdDate = $createdDate;

        return $this;
    }

    public function getUpdatedDate(): \DateTime
    {
        return $this->updatedDate;
    }

    public function setUpdatedDate(\DateTime $updatedDate): self
    {
        $this->initialized['updatedDate'] = true;
        $this->updatedDate = $updatedDate;

        return $this;
    }

    public function getAccountingCode(): ?string
    {
        return $this->accountingCode;
    }

    public function setAccountingCode(?string $accountingCode): self
    {
        $this->initialized['accountingCode'] = true;
        $this->accountingCode = $accountingCode;

        return $this;
    }

    /**
     * @return list<VeterinaryEstablishmentServicePeriodResponseItemAttributesItem>
     */
    public function getAttributes(): array
    {
        return $this->attributes;
    }

    /**
     * @param list<VeterinaryEstablishmentServicePeriodResponseItemAttributesItem> $attributes
     */
    public function setAttributes(array $attributes): self
    {
        $this->initialized['attributes'] = true;
        $this->attributes = $attributes;

        return $this;
    }

    public function getCalculatedPriceWithoutVat(): int
    {
        return $this->calculatedPriceWithoutVat;
    }

    public function setCalculatedPriceWithoutVat(int $calculatedPriceWithoutVat): self
    {
        $this->initialized['calculatedPriceWithoutVat'] = true;
        $this->calculatedPriceWithoutVat = $calculatedPriceWithoutVat;

        return $this;
    }

    public function getCalculatedPriceWithVat(): int
    {
        return $this->calculatedPriceWithVat;
    }

    public function setCalculatedPriceWithVat(int $calculatedPriceWithVat): self
    {
        $this->initialized['calculatedPriceWithVat'] = true;
        $this->calculatedPriceWithVat = $calculatedPriceWithVat;

        return $this;
    }

    public function getEndDate(): \DateTime
    {
        return $this->endDate;
    }

    public function setEndDate(\DateTime $endDate): self
    {
        $this->initialized['endDate'] = true;
        $this->endDate = $endDate;

        return $this;
    }

    public function getPaymentMethod(): string
    {
        return $this->paymentMethod;
    }

    public function setPaymentMethod(string $paymentMethod): self
    {
        $this->initialized['paymentMethod'] = true;
        $this->paymentMethod = $paymentMethod;

        return $this;
    }

    public function getShouldGenerateInvoice(): bool
    {
        return $this->shouldGenerateInvoice;
    }

    public function setShouldGenerateInvoice(bool $shouldGenerateInvoice): self
    {
        $this->initialized['shouldGenerateInvoice'] = true;
        $this->shouldGenerateInvoice = $shouldGenerateInvoice;

        return $this;
    }

    /**
     * Nullable Id - Response Model.
     */
    public function getSpecificBillingAccount(): ?NullableIdResponse
    {
        return $this->specificBillingAccount;
    }

    /**
     * Nullable Id - Response Model.
     */
    public function setSpecificBillingAccount(?NullableIdResponse $specificBillingAccount): self
    {
        $this->initialized['specificBillingAccount'] = true;
        $this->specificBillingAccount = $specificBillingAccount;

        return $this;
    }

    /**
     * Nullable Id - Response Model.
     */
    public function getSpecificVeterinaryGroup(): ?NullableIdResponse
    {
        return $this->specificVeterinaryGroup;
    }

    /**
     * Nullable Id - Response Model.
     */
    public function setSpecificVeterinaryGroup(?NullableIdResponse $specificVeterinaryGroup): self
    {
        $this->initialized['specificVeterinaryGroup'] = true;
        $this->specificVeterinaryGroup = $specificVeterinaryGroup;

        return $this;
    }

    public function getStartDate(): \DateTime
    {
        return $this->startDate;
    }

    public function setStartDate(\DateTime $startDate): self
    {
        $this->initialized['startDate'] = true;
        $this->startDate = $startDate;

        return $this;
    }

    /**
     * Id - Response Model.
     */
    public function getVeterinaryEstablishment(): IdResponse
    {
        return $this->veterinaryEstablishment;
    }

    /**
     * Id - Response Model.
     */
    public function setVeterinaryEstablishment(IdResponse $veterinaryEstablishment): self
    {
        $this->initialized['veterinaryEstablishment'] = true;
        $this->veterinaryEstablishment = $veterinaryEstablishment;

        return $this;
    }

    /**
     * Id - Response Model.
     */
    public function getVeterinaryEstablishmentServiceSubscription(): IdResponse
    {
        return $this->veterinaryEstablishmentServiceSubscription;
    }

    /**
     * Id - Response Model.
     */
    public function setVeterinaryEstablishmentServiceSubscription(IdResponse $veterinaryEstablishmentServiceSubscription): self
    {
        $this->initialized['veterinaryEstablishmentServiceSubscription'] = true;
        $this->veterinaryEstablishmentServiceSubscription = $veterinaryEstablishmentServiceSubscription;

        return $this;
    }

    /**
     * Id - Response Model.
     */
    public function getVeterinaryServiceOption(): IdResponse
    {
        return $this->veterinaryServiceOption;
    }

    /**
     * Id - Response Model.
     */
    public function setVeterinaryServiceOption(IdResponse $veterinaryServiceOption): self
    {
        $this->initialized['veterinaryServiceOption'] = true;
        $this->veterinaryServiceOption = $veterinaryServiceOption;

        return $this;
    }
}
