<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class VeterinaryEstablishmentResponse extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var string
     */
    protected $id;

    /**
     * @var \DateTime
     */
    protected $createdDate;

    /**
     * @var \DateTime
     */
    protected $updatedDate;

    /**
     * @var list<IdResponse>
     */
    protected $addresses;

    /**
     * Nullable Id - Response Model.
     *
     * @var NullableIdResponse|null
     */
    protected $banner;

    /**
     * @var string|null
     */
    protected $customName;

    /**
     * @var int|null
     */
    protected $entryNumber;

    /**
     * @var string|null
     */
    protected $internalCommentary;

    /**
     * Id - Response Model.
     *
     * @var IdResponse
     */
    protected $legalStructure;

    /**
     * Nullable Id - Response Model.
     *
     * @var NullableIdResponse|null
     */
    protected $logo;

    /**
     * @var string|null
     */
    protected $longDescription;

    /**
     * Nullable Id - Response Model.
     *
     * @var NullableIdResponse|null
     */
    protected $mainAddress;

    /**
     * Nullable Id - Response Model.
     *
     * @var NullableIdResponse|null
     */
    protected $mainBillingAccount;

    /**
     * @var string
     */
    protected $name;

    /**
     * @var string|null
     */
    protected $personalisedMention;

    /**
     * @var list<IdResponse>|null
     */
    protected $pictures;

    /**
     * @var string
     */
    protected $privilegedCode;

    /**
     * @var ScheduleResponse
     */
    protected $schedule;

    /**
     * @var string
     */
    protected $serviceVatCategory;

    /**
     * @var string|null
     */
    protected $shortDescription;

    /**
     * @var string
     */
    protected $type;

    /**
     * @var list<IdResponse>
     */
    protected $veterinaryEstablishmentLabellings;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getId(): string
    {
        return $this->id;
    }

    public function setId(string $id): self
    {
        $this->initialized['id'] = true;
        $this->id = $id;

        return $this;
    }

    public function getCreatedDate(): \DateTime
    {
        return $this->createdDate;
    }

    public function setCreatedDate(\DateTime $createdDate): self
    {
        $this->initialized['createdDate'] = true;
        $this->createdDate = $createdDate;

        return $this;
    }

    public function getUpdatedDate(): \DateTime
    {
        return $this->updatedDate;
    }

    public function setUpdatedDate(\DateTime $updatedDate): self
    {
        $this->initialized['updatedDate'] = true;
        $this->updatedDate = $updatedDate;

        return $this;
    }

    /**
     * @return list<IdResponse>
     */
    public function getAddresses(): array
    {
        return $this->addresses;
    }

    /**
     * @param list<IdResponse> $addresses
     */
    public function setAddresses(array $addresses): self
    {
        $this->initialized['addresses'] = true;
        $this->addresses = $addresses;

        return $this;
    }

    /**
     * Nullable Id - Response Model.
     */
    public function getBanner(): ?NullableIdResponse
    {
        return $this->banner;
    }

    /**
     * Nullable Id - Response Model.
     */
    public function setBanner(?NullableIdResponse $banner): self
    {
        $this->initialized['banner'] = true;
        $this->banner = $banner;

        return $this;
    }

    public function getCustomName(): ?string
    {
        return $this->customName;
    }

    public function setCustomName(?string $customName): self
    {
        $this->initialized['customName'] = true;
        $this->customName = $customName;

        return $this;
    }

    public function getEntryNumber(): ?int
    {
        return $this->entryNumber;
    }

    public function setEntryNumber(?int $entryNumber): self
    {
        $this->initialized['entryNumber'] = true;
        $this->entryNumber = $entryNumber;

        return $this;
    }

    public function getInternalCommentary(): ?string
    {
        return $this->internalCommentary;
    }

    public function setInternalCommentary(?string $internalCommentary): self
    {
        $this->initialized['internalCommentary'] = true;
        $this->internalCommentary = $internalCommentary;

        return $this;
    }

    /**
     * Id - Response Model.
     */
    public function getLegalStructure(): IdResponse
    {
        return $this->legalStructure;
    }

    /**
     * Id - Response Model.
     */
    public function setLegalStructure(IdResponse $legalStructure): self
    {
        $this->initialized['legalStructure'] = true;
        $this->legalStructure = $legalStructure;

        return $this;
    }

    /**
     * Nullable Id - Response Model.
     */
    public function getLogo(): ?NullableIdResponse
    {
        return $this->logo;
    }

    /**
     * Nullable Id - Response Model.
     */
    public function setLogo(?NullableIdResponse $logo): self
    {
        $this->initialized['logo'] = true;
        $this->logo = $logo;

        return $this;
    }

    public function getLongDescription(): ?string
    {
        return $this->longDescription;
    }

    public function setLongDescription(?string $longDescription): self
    {
        $this->initialized['longDescription'] = true;
        $this->longDescription = $longDescription;

        return $this;
    }

    /**
     * Nullable Id - Response Model.
     */
    public function getMainAddress(): ?NullableIdResponse
    {
        return $this->mainAddress;
    }

    /**
     * Nullable Id - Response Model.
     */
    public function setMainAddress(?NullableIdResponse $mainAddress): self
    {
        $this->initialized['mainAddress'] = true;
        $this->mainAddress = $mainAddress;

        return $this;
    }

    /**
     * Nullable Id - Response Model.
     */
    public function getMainBillingAccount(): ?NullableIdResponse
    {
        return $this->mainBillingAccount;
    }

    /**
     * Nullable Id - Response Model.
     */
    public function setMainBillingAccount(?NullableIdResponse $mainBillingAccount): self
    {
        $this->initialized['mainBillingAccount'] = true;
        $this->mainBillingAccount = $mainBillingAccount;

        return $this;
    }

    public function getName(): string
    {
        return $this->name;
    }

    public function setName(string $name): self
    {
        $this->initialized['name'] = true;
        $this->name = $name;

        return $this;
    }

    public function getPersonalisedMention(): ?string
    {
        return $this->personalisedMention;
    }

    public function setPersonalisedMention(?string $personalisedMention): self
    {
        $this->initialized['personalisedMention'] = true;
        $this->personalisedMention = $personalisedMention;

        return $this;
    }

    /**
     * @return list<IdResponse>|null
     */
    public function getPictures(): ?array
    {
        return $this->pictures;
    }

    /**
     * @param list<IdResponse>|null $pictures
     */
    public function setPictures(?array $pictures): self
    {
        $this->initialized['pictures'] = true;
        $this->pictures = $pictures;

        return $this;
    }

    public function getPrivilegedCode(): string
    {
        return $this->privilegedCode;
    }

    public function setPrivilegedCode(string $privilegedCode): self
    {
        $this->initialized['privilegedCode'] = true;
        $this->privilegedCode = $privilegedCode;

        return $this;
    }

    public function getSchedule(): ScheduleResponse
    {
        return $this->schedule;
    }

    public function setSchedule(ScheduleResponse $schedule): self
    {
        $this->initialized['schedule'] = true;
        $this->schedule = $schedule;

        return $this;
    }

    public function getServiceVatCategory(): string
    {
        return $this->serviceVatCategory;
    }

    public function setServiceVatCategory(string $serviceVatCategory): self
    {
        $this->initialized['serviceVatCategory'] = true;
        $this->serviceVatCategory = $serviceVatCategory;

        return $this;
    }

    public function getShortDescription(): ?string
    {
        return $this->shortDescription;
    }

    public function setShortDescription(?string $shortDescription): self
    {
        $this->initialized['shortDescription'] = true;
        $this->shortDescription = $shortDescription;

        return $this;
    }

    public function getType(): string
    {
        return $this->type;
    }

    public function setType(string $type): self
    {
        $this->initialized['type'] = true;
        $this->type = $type;

        return $this;
    }

    /**
     * @return list<IdResponse>
     */
    public function getVeterinaryEstablishmentLabellings(): array
    {
        return $this->veterinaryEstablishmentLabellings;
    }

    /**
     * @param list<IdResponse> $veterinaryEstablishmentLabellings
     */
    public function setVeterinaryEstablishmentLabellings(array $veterinaryEstablishmentLabellings): self
    {
        $this->initialized['veterinaryEstablishmentLabellings'] = true;
        $this->veterinaryEstablishmentLabellings = $veterinaryEstablishmentLabellings;

        return $this;
    }
}
