<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class VeterinaryEstablishmentActivityRequest extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var int
     */
    protected $caninePercent;

    /**
     * @var int
     */
    protected $equinePercent;

    /**
     * @var int
     */
    protected $ruralPercent;

    /**
     * Id - Common Request Model.
     *
     * @var IdRequest
     */
    protected $veterinaryEstablishment;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getCaninePercent(): int
    {
        return $this->caninePercent;
    }

    public function setCaninePercent(int $caninePercent): self
    {
        $this->initialized['caninePercent'] = true;
        $this->caninePercent = $caninePercent;

        return $this;
    }

    public function getEquinePercent(): int
    {
        return $this->equinePercent;
    }

    public function setEquinePercent(int $equinePercent): self
    {
        $this->initialized['equinePercent'] = true;
        $this->equinePercent = $equinePercent;

        return $this;
    }

    public function getRuralPercent(): int
    {
        return $this->ruralPercent;
    }

    public function setRuralPercent(int $ruralPercent): self
    {
        $this->initialized['ruralPercent'] = true;
        $this->ruralPercent = $ruralPercent;

        return $this;
    }

    /**
     * Id - Common Request Model.
     */
    public function getVeterinaryEstablishment(): IdRequest
    {
        return $this->veterinaryEstablishment;
    }

    /**
     * Id - Common Request Model.
     */
    public function setVeterinaryEstablishment(IdRequest $veterinaryEstablishment): self
    {
        $this->initialized['veterinaryEstablishment'] = true;
        $this->veterinaryEstablishment = $veterinaryEstablishment;

        return $this;
    }
}
