<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class V1CustomerProfilesPostBody extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var \DateTime|null
     */
    protected $birthDate;

    /**
     * @var string|null
     */
    protected $birthName;

    /**
     * @var string|null
     */
    protected $companyDescription;

    /**
     * Id - Common Request Model.
     *
     * @var V1CustomerProfilesPostBodyCustomer
     */
    protected $customer;

    /**
     * @var string|null
     */
    protected $firstname;

    /**
     * @var string|null
     */
    protected $gender;

    /**
     * @var string|null
     */
    protected $lastname;

    /**
     * @var string
     */
    protected $source;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getBirthDate(): ?\DateTime
    {
        return $this->birthDate;
    }

    public function setBirthDate(?\DateTime $birthDate): self
    {
        $this->initialized['birthDate'] = true;
        $this->birthDate = $birthDate;

        return $this;
    }

    public function getBirthName(): ?string
    {
        return $this->birthName;
    }

    public function setBirthName(?string $birthName): self
    {
        $this->initialized['birthName'] = true;
        $this->birthName = $birthName;

        return $this;
    }

    public function getCompanyDescription(): ?string
    {
        return $this->companyDescription;
    }

    public function setCompanyDescription(?string $companyDescription): self
    {
        $this->initialized['companyDescription'] = true;
        $this->companyDescription = $companyDescription;

        return $this;
    }

    /**
     * Id - Common Request Model.
     */
    public function getCustomer(): V1CustomerProfilesPostBodyCustomer
    {
        return $this->customer;
    }

    /**
     * Id - Common Request Model.
     */
    public function setCustomer(V1CustomerProfilesPostBodyCustomer $customer): self
    {
        $this->initialized['customer'] = true;
        $this->customer = $customer;

        return $this;
    }

    public function getFirstname(): ?string
    {
        return $this->firstname;
    }

    public function setFirstname(?string $firstname): self
    {
        $this->initialized['firstname'] = true;
        $this->firstname = $firstname;

        return $this;
    }

    public function getGender(): ?string
    {
        return $this->gender;
    }

    public function setGender(?string $gender): self
    {
        $this->initialized['gender'] = true;
        $this->gender = $gender;

        return $this;
    }

    public function getLastname(): ?string
    {
        return $this->lastname;
    }

    public function setLastname(?string $lastname): self
    {
        $this->initialized['lastname'] = true;
        $this->lastname = $lastname;

        return $this;
    }

    public function getSource(): string
    {
        return $this->source;
    }

    public function setSource(string $source): self
    {
        $this->initialized['source'] = true;
        $this->source = $source;

        return $this;
    }
}
