<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class V1ContactsPostBody extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var string|null
     */
    protected $addressSupplement;

    /**
     * @var string|null
     */
    protected $city;

    /**
     * @var string|null
     */
    protected $comment;

    /**
     * Nullable Company Detail - Request Model.
     *
     * @var V1ContactsPostBodyCompanyDetail|null
     */
    protected $companyDetail;

    /**
     * Contact Country - Request Model.
     *
     * @var string
     */
    protected $country;

    /**
     * Id - Common Request Model.
     *
     * @var V1ContactsPostBodyCustomerProfile
     */
    protected $customerProfile;

    /**
     * @var string|null
     */
    protected $department;

    /**
     * @var string|null
     */
    protected $email;

    /**
     * @var string
     */
    protected $entitled;

    /**
     * Nullable Geolocation - Request Model.
     *
     * @var V1ContactsPostBodyGeolocation|null
     */
    protected $geolocation;

    /**
     * @var string|null
     */
    protected $phoneNumber;

    /**
     * @var string|null
     */
    protected $postalCode;

    /**
     * @var string|null
     */
    protected $postBoxNumber;

    /**
     * @var string|null
     */
    protected $recipientIdentity;

    /**
     * @var string|null
     */
    protected $region;

    /**
     * @var string|null
     */
    protected $streetName;

    /**
     * @var string|null
     */
    protected $streetNumber;

    /**
     * @var string|null
     */
    protected $type;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getAddressSupplement(): ?string
    {
        return $this->addressSupplement;
    }

    public function setAddressSupplement(?string $addressSupplement): self
    {
        $this->initialized['addressSupplement'] = true;
        $this->addressSupplement = $addressSupplement;

        return $this;
    }

    public function getCity(): ?string
    {
        return $this->city;
    }

    public function setCity(?string $city): self
    {
        $this->initialized['city'] = true;
        $this->city = $city;

        return $this;
    }

    public function getComment(): ?string
    {
        return $this->comment;
    }

    public function setComment(?string $comment): self
    {
        $this->initialized['comment'] = true;
        $this->comment = $comment;

        return $this;
    }

    /**
     * Nullable Company Detail - Request Model.
     */
    public function getCompanyDetail(): ?V1ContactsPostBodyCompanyDetail
    {
        return $this->companyDetail;
    }

    /**
     * Nullable Company Detail - Request Model.
     */
    public function setCompanyDetail(?V1ContactsPostBodyCompanyDetail $companyDetail): self
    {
        $this->initialized['companyDetail'] = true;
        $this->companyDetail = $companyDetail;

        return $this;
    }

    /**
     * Contact Country - Request Model.
     */
    public function getCountry(): string
    {
        return $this->country;
    }

    /**
     * Contact Country - Request Model.
     */
    public function setCountry(string $country): self
    {
        $this->initialized['country'] = true;
        $this->country = $country;

        return $this;
    }

    /**
     * Id - Common Request Model.
     */
    public function getCustomerProfile(): V1ContactsPostBodyCustomerProfile
    {
        return $this->customerProfile;
    }

    /**
     * Id - Common Request Model.
     */
    public function setCustomerProfile(V1ContactsPostBodyCustomerProfile $customerProfile): self
    {
        $this->initialized['customerProfile'] = true;
        $this->customerProfile = $customerProfile;

        return $this;
    }

    public function getDepartment(): ?string
    {
        return $this->department;
    }

    public function setDepartment(?string $department): self
    {
        $this->initialized['department'] = true;
        $this->department = $department;

        return $this;
    }

    public function getEmail(): ?string
    {
        return $this->email;
    }

    public function setEmail(?string $email): self
    {
        $this->initialized['email'] = true;
        $this->email = $email;

        return $this;
    }

    public function getEntitled(): string
    {
        return $this->entitled;
    }

    public function setEntitled(string $entitled): self
    {
        $this->initialized['entitled'] = true;
        $this->entitled = $entitled;

        return $this;
    }

    /**
     * Nullable Geolocation - Request Model.
     */
    public function getGeolocation(): ?V1ContactsPostBodyGeolocation
    {
        return $this->geolocation;
    }

    /**
     * Nullable Geolocation - Request Model.
     */
    public function setGeolocation(?V1ContactsPostBodyGeolocation $geolocation): self
    {
        $this->initialized['geolocation'] = true;
        $this->geolocation = $geolocation;

        return $this;
    }

    public function getPhoneNumber(): ?string
    {
        return $this->phoneNumber;
    }

    public function setPhoneNumber(?string $phoneNumber): self
    {
        $this->initialized['phoneNumber'] = true;
        $this->phoneNumber = $phoneNumber;

        return $this;
    }

    public function getPostalCode(): ?string
    {
        return $this->postalCode;
    }

    public function setPostalCode(?string $postalCode): self
    {
        $this->initialized['postalCode'] = true;
        $this->postalCode = $postalCode;

        return $this;
    }

    public function getPostBoxNumber(): ?string
    {
        return $this->postBoxNumber;
    }

    public function setPostBoxNumber(?string $postBoxNumber): self
    {
        $this->initialized['postBoxNumber'] = true;
        $this->postBoxNumber = $postBoxNumber;

        return $this;
    }

    public function getRecipientIdentity(): ?string
    {
        return $this->recipientIdentity;
    }

    public function setRecipientIdentity(?string $recipientIdentity): self
    {
        $this->initialized['recipientIdentity'] = true;
        $this->recipientIdentity = $recipientIdentity;

        return $this;
    }

    public function getRegion(): ?string
    {
        return $this->region;
    }

    public function setRegion(?string $region): self
    {
        $this->initialized['region'] = true;
        $this->region = $region;

        return $this;
    }

    public function getStreetName(): ?string
    {
        return $this->streetName;
    }

    public function setStreetName(?string $streetName): self
    {
        $this->initialized['streetName'] = true;
        $this->streetName = $streetName;

        return $this;
    }

    public function getStreetNumber(): ?string
    {
        return $this->streetNumber;
    }

    public function setStreetNumber(?string $streetNumber): self
    {
        $this->initialized['streetNumber'] = true;
        $this->streetNumber = $streetNumber;

        return $this;
    }

    public function getType(): ?string
    {
        return $this->type;
    }

    public function setType(?string $type): self
    {
        $this->initialized['type'] = true;
        $this->type = $type;

        return $this;
    }
}
