<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class PermissionGrant extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var list<string>
     */
    protected $allowed;

    /**
     * @var list<string>
     */
    protected $denied;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    /**
     * @return list<string>
     */
    public function getAllowed(): array
    {
        return $this->allowed;
    }

    /**
     * @param list<string> $allowed
     */
    public function setAllowed(array $allowed): self
    {
        $this->initialized['allowed'] = true;
        $this->allowed = $allowed;

        return $this;
    }

    /**
     * @return list<string>
     */
    public function getDenied(): array
    {
        return $this->denied;
    }

    /**
     * @param list<string> $denied
     */
    public function setDenied(array $denied): self
    {
        $this->initialized['denied'] = true;
        $this->denied = $denied;

        return $this;
    }
}
