<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class DocumentRequest extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var string
     */
    protected $dataUri;

    /**
     * @var string
     */
    protected $originalName;

    /**
     * @var string|null
     */
    protected $status;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getDataUri(): string
    {
        return $this->dataUri;
    }

    public function setDataUri(string $dataUri): self
    {
        $this->initialized['dataUri'] = true;
        $this->dataUri = $dataUri;

        return $this;
    }

    public function getOriginalName(): string
    {
        return $this->originalName;
    }

    public function setOriginalName(string $originalName): self
    {
        $this->initialized['originalName'] = true;
        $this->originalName = $originalName;

        return $this;
    }

    public function getStatus(): ?string
    {
        return $this->status;
    }

    public function setStatus(?string $status): self
    {
        $this->initialized['status'] = true;
        $this->status = $status;

        return $this;
    }
}
