<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class ComponentsSchemasRequiredMandateResponse extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var string
     */
    protected $id;

    /**
     * @var \DateTime
     */
    protected $createdDate;

    /**
     * @var \DateTime
     */
    protected $updatedDate;

    /**
     * Id - Response Model.
     *
     * @var IdResponse
     */
    protected $billingAccount;

    /**
     * @var ComponentsSchemasRequiredMandateResponseFilledMandate
     */
    protected $filledMandate;

    /**
     * Id - Response Model.
     *
     * @var IdResponse
     */
    protected $mandate;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getId(): string
    {
        return $this->id;
    }

    public function setId(string $id): self
    {
        $this->initialized['id'] = true;
        $this->id = $id;

        return $this;
    }

    public function getCreatedDate(): \DateTime
    {
        return $this->createdDate;
    }

    public function setCreatedDate(\DateTime $createdDate): self
    {
        $this->initialized['createdDate'] = true;
        $this->createdDate = $createdDate;

        return $this;
    }

    public function getUpdatedDate(): \DateTime
    {
        return $this->updatedDate;
    }

    public function setUpdatedDate(\DateTime $updatedDate): self
    {
        $this->initialized['updatedDate'] = true;
        $this->updatedDate = $updatedDate;

        return $this;
    }

    /**
     * Id - Response Model.
     */
    public function getBillingAccount(): IdResponse
    {
        return $this->billingAccount;
    }

    /**
     * Id - Response Model.
     */
    public function setBillingAccount(IdResponse $billingAccount): self
    {
        $this->initialized['billingAccount'] = true;
        $this->billingAccount = $billingAccount;

        return $this;
    }

    public function getFilledMandate(): ComponentsSchemasRequiredMandateResponseFilledMandate
    {
        return $this->filledMandate;
    }

    public function setFilledMandate(ComponentsSchemasRequiredMandateResponseFilledMandate $filledMandate): self
    {
        $this->initialized['filledMandate'] = true;
        $this->filledMandate = $filledMandate;

        return $this;
    }

    /**
     * Id - Response Model.
     */
    public function getMandate(): IdResponse
    {
        return $this->mandate;
    }

    /**
     * Id - Response Model.
     */
    public function setMandate(IdResponse $mandate): self
    {
        $this->initialized['mandate'] = true;
        $this->mandate = $mandate;

        return $this;
    }
}
