<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Endpoint;

class PutPrincipalItem extends \NoahVet\Reef\Jane\Runtime\Client\BaseEndpoint implements \NoahVet\Reef\Jane\Runtime\Client\Endpoint
{
    use \NoahVet\Reef\Jane\Runtime\Client\EndpointTrait;

    /**
     * Update a principal.
     */
    public function __construct(\NoahVet\Reef\Jane\Model\PrincipalPut $requestBody)
    {
        $this->body = $requestBody;
    }

    public function getMethod(): string
    {
        return 'PUT';
    }

    public function getUri(): string
    {
        return '/api/principals/{id}';
    }

    public function getBody(\Symfony\Component\Serializer\SerializerInterface $serializer, $streamFactory = null): array
    {
        if ($this->body instanceof \NoahVet\Reef\Jane\Model\PrincipalPut) {
            return [['Content-Type' => ['application/json']], $serializer->serialize($this->body, 'json')];
        }

        return [[], null];
    }

    public function getExtraHeaders(): array
    {
        return ['Accept' => ['application/json']];
    }

    public function getAuthenticationScopes(): array
    {
        return ['BearerAuth'];
    }

    /**
     * @return \NoahVet\Reef\Jane\Model\PrincipalGet
     *
     * @throws \NoahVet\Reef\Jane\Exception\PutPrincipalItemBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\PutPrincipalItemUnprocessableEntityException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    protected function transformResponseBody(\Psr\Http\Message\ResponseInterface $response, \Symfony\Component\Serializer\SerializerInterface $serializer, ?string $contentType = null)
    {
        $status = $response->getStatusCode();
        $body = (string) $response->getBody();
        if ((null === $contentType) === false && (200 === $status && false !== \mb_strpos($contentType, 'application/json'))) {
            return $serializer->deserialize($body, 'NoahVet\\Reef\\Jane\\Model\\PrincipalGet', 'json');
        }
        if (400 === $status) {
            throw new \NoahVet\Reef\Jane\Exception\PutPrincipalItemBadRequestException($response);
        }
        if (422 === $status) {
            throw new \NoahVet\Reef\Jane\Exception\PutPrincipalItemUnprocessableEntityException($response);
        }
        throw new \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException($status, $body);
    }
}
