<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Endpoint;

class PostVeterinaryEstablishmentActivity extends \NoahVet\Reef\Jane\Runtime\Client\BaseEndpoint implements \NoahVet\Reef\Jane\Runtime\Client\Endpoint
{
    use \NoahVet\Reef\Jane\Runtime\Client\EndpointTrait;

    /**
     * Create a Veterinary Establishment Activity.
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     */
    public function __construct(\NoahVet\Reef\Jane\Model\VeterinaryEstablishmentActivityRequest $requestBody, array $headerParameters = [])
    {
        $this->body = $requestBody;
        $this->headerParameters = $headerParameters;
    }

    public function getMethod(): string
    {
        return 'POST';
    }

    public function getUri(): string
    {
        return '/v1/veterinary_establishment_activities';
    }

    public function getBody(\Symfony\Component\Serializer\SerializerInterface $serializer, $streamFactory = null): array
    {
        if ($this->body instanceof \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentActivityRequest) {
            return [['Content-Type' => ['application/json']], $serializer->serialize($this->body, 'json')];
        }

        return [[], null];
    }

    public function getExtraHeaders(): array
    {
        return ['Accept' => ['application/json']];
    }

    public function getAuthenticationScopes(): array
    {
        return ['BearerAuth'];
    }

    protected function getHeadersOptionsResolver(): \Symfony\Component\OptionsResolver\OptionsResolver
    {
        $optionsResolver = parent::getHeadersOptionsResolver();
        $optionsResolver->setDefined(['Accept-Language']);
        $optionsResolver->setRequired([]);
        $optionsResolver->setDefaults([]);
        $optionsResolver->addAllowedTypes('Accept-Language', ['string']);

        return $optionsResolver;
    }

    /**
     * @return \NoahVet\Reef\Jane\Model\SchemasVeterinaryEstablishmentActivityResponse
     *
     * @throws \NoahVet\Reef\Jane\Exception\PostVeterinaryEstablishmentActivityBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\PostVeterinaryEstablishmentActivityNotFoundException
     * @throws \NoahVet\Reef\Jane\Exception\PostVeterinaryEstablishmentActivityConflictException
     * @throws \NoahVet\Reef\Jane\Exception\PostVeterinaryEstablishmentActivityInternalServerErrorException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    protected function transformResponseBody(\Psr\Http\Message\ResponseInterface $response, \Symfony\Component\Serializer\SerializerInterface $serializer, ?string $contentType = null)
    {
        $status = $response->getStatusCode();
        $body = (string) $response->getBody();
        if ((null === $contentType) === false && (201 === $status && false !== \mb_strpos($contentType, 'application/json'))) {
            return $serializer->deserialize($body, 'NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryEstablishmentActivityResponse', 'json');
        }
        if (400 === $status) {
            throw new \NoahVet\Reef\Jane\Exception\PostVeterinaryEstablishmentActivityBadRequestException($response);
        }
        if (404 === $status) {
            throw new \NoahVet\Reef\Jane\Exception\PostVeterinaryEstablishmentActivityNotFoundException($response);
        }
        if (409 === $status) {
            throw new \NoahVet\Reef\Jane\Exception\PostVeterinaryEstablishmentActivityConflictException($response);
        }
        if (500 === $status) {
            throw new \NoahVet\Reef\Jane\Exception\PostVeterinaryEstablishmentActivityInternalServerErrorException($response);
        }
        throw new \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException($status, $body);
    }
}
