<?php

declare(strict_types=1);

namespace NoahVet\Reef\Domain\Tool;

class VatTool implements VatToolInterface
{
    protected static int $calculBase = 10000;

    public static function addVat(int $amountWithoutVat, int $vatAmount): int
    {
        return (int) ($amountWithoutVat * (1 + $vatAmount / self::$calculBase));
    }

    public static function getVat(int $amountWithVat, int $amountWithoutVat): int
    {
        if (0 >= $amountWithoutVat) {
            throw new \InvalidArgumentException(
                'The `$amountWithoutVat` should be greater than 0.',
            );
        }
        if ($amountWithVat < $amountWithoutVat) {
            throw new \InvalidArgumentException(
                'The `$amountWithVat` should be lower than or equals to `$amountWithVat`.',
            );
        }

        return (int) (\round(($amountWithVat / $amountWithoutVat) - 1, 4) * self::$calculBase);
    }

    public static function removeVat(int $amountWithVat, int $vatAmount): int
    {
        return (int) ($amountWithVat / (1 + $vatAmount / self::$calculBase));
    }
}
