<?php

declare(strict_types=1);

namespace NoahVet\Reef\Domain\Tool;

interface DateToolInterface extends ToolInterface
{
    public const UTC = 'UTC';

    /**
     * E.g.
     *
     * Before
     *
     * "2024-05-16T10:45:26+00:00"
     * or
     * null
     *
     * After
     *
     * DateTime with value 2024-05-16T08:45:26+00:00
     * or
     * null
     */
    public static function fromNullableStringToDateTime(
        ?string $dateString,
        string $format = \DateTimeInterface::ATOM,
        string $timeZone = self::UTC,
        bool $isImmutable = true,
    ): ?\DateTimeInterface;

    /**
     * E.g.
     *
     * Before
     *
     * "2024-05-16T10:45:26+00:00"
     *
     * After
     *
     * DateTime with value 2024-05-16T08:45:26+00:00
     */
    public static function fromStringToDateTime(
        string $dateString,
        string $format = \DateTimeInterface::ATOM,
        string $timeZone = self::UTC,
        bool $isImmutable = true,
    ): \DateTimeInterface;

    /**
     * E.g.
     *
     * Before
     *
     * "2024-05-16T10:00:00+00:00"
     *
     * After
     *
     * "2024-05-16T00:00:00+00:00"
     */
    public static function toFirstSecondOfTheDay(\DateTimeInterface|\DateTime $datetime): \DateTimeInterface;

    /**
     * E.g.
     *
     * Before
     *
     * "2024-05-16T10:00:00+00:00"
     *
     * After
     *
     * "2024-05-01T00:00:00+00:00"
     */
    public static function toFirstSecondOfTheMonth(\DateTimeInterface|\DateTime $datetime): \DateTimeInterface;

    /**
     * E.g.
     *
     * Before
     *
     * "2024-05-16T10:00:00+00:00"
     *
     * After
     *
     * "2024-05-16T23:59:59+00:00"
     */
    public static function toLastSecondOfTheDay(\DateTimeInterface|\DateTime $datetime): \DateTimeInterface;

    /**
     * E.g.
     *
     * Before
     *
     * "2024-05-16T10:00:00+00:00"
     *
     * After
     *
     * "2024-05-31T23:59:59+00:00"
     */
    public static function toLastSecondOfTheMonth(\DateTimeInterface|\DateTime $datetime): \DateTimeInterface;

    /**
     * E.g.
     *
     * Before
     *
     * "2024-05-16T10:00:00+00:00"
     *
     * After
     *
     * "2024-04-31T23:59:59+00:00"
     */
    public static function toLastSecondOfThePreviousMonth(\DateTimeInterface|\DateTime $datetime): \DateTimeInterface;

    public static function isDate(string $date, string $expectedFormat): bool;
}
