<?php

declare(strict_types=1);

namespace NoahVet\Reef\Domain\Process;

class SymfonyProcess
{
    public static function getPhpBinaryPath(): string
    {
        if (\PHP_SAPI === 'cli') {
            $phpBinary = \PHP_BINARY;

            if ('/php' !== \substr($phpBinary, -4)) {
                return $phpBinary;
            }
        }

        if (\defined('PHP_BINARY')) {
            return \PHP_BINARY;
        }

        return '/usr/local/bin/php';
    }

    public static function getSymfonyConsolePath(): string
    {
        $consolePath = (isset($_SERVER['PHP_SELF']) && \is_file($_SERVER['PHP_SELF'])) ? $_SERVER['PHP_SELF'] : 'bin/console';
        if ('/console' !== \substr($consolePath, -11)) {
            $consolePath = 'bin/console';
        }

        return $consolePath;
    }
}
