<?php

declare(strict_types=1);

namespace NoahVet\Reef\Domain\Log;

class SimplePrincipal implements SimplePrincipalInterface
{
    private string $id;

    public function __construct(string $id)
    {
        if (!\preg_match('{^[0-9a-f]{8}(?:-[0-9a-f]{4}){3}-[0-9a-f]{12}$}Di', $id)) {
            throw new \LogicException("The principal id `$id` should be a valid uuid.");
        }
        $this->id = $id;
    }

    public function getId(): string
    {
        return $this->id;
    }
}
