<?php

declare(strict_types=1);

namespace NoahVet\Reef\Domain\Invoice\Enum;

use NoahVet\Reef\Domain\Common\EnumTrait;
use NoahVet\Reef\Domain\Common\StringEnumInterface;

enum PaymentStatusEnum: string implements StringEnumInterface
{
    use EnumTrait;

    /**
     * 100% paid.
     */
    case PAID = 'PAID';

    /**
     * Between 0.01% and 99.99% paid.
     */
    case PARTIAL_PAID = 'PARTIAL_PAID';

    /**
     * 0% paid.
     */
    case REJECTED = 'REJECTED';

    /**
     * 0% paid. When you know that the amount can never be collected.
     */
    case UNCOLLECTIBLE = 'UNCOLLECTIBLE';

    /**
     * 0% paid.
     */
    case UNPAID = 'UNPAID';
}
