<?php

declare(strict_types=1);

namespace NoahVet\Reef\Controller\Common;

use NoahVet\Reef\Controller\AbstractController;
use NoahVet\Reef\Mapper\Common\One\Get\AbstractGetMapperInterface;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Response;

/**
 * @template EntityType of object
 * @template ResponseDtoType of object
 */
abstract class AbstractGetController extends AbstractController
{
    /**
     * @param array<string, mixed> $data
     */
    protected function getResponse(array $data): Response
    {
        return new JsonResponse($data, Response::HTTP_OK, $this->headers);
    }

    /**
     * @param AbstractGetMapperInterface<EntityType> $mapper
     * @param EntityType                             $entity
     * @param class-string<ResponseDtoType>          $responseDtoFqcn
     *
     * @return array<string, mixed>
     */
    protected function serializeResponse(
        AbstractGetMapperInterface $mapper,
        object $entity,
        string $responseDtoFqcn,
    ): array {
        return $mapper->normalizeResponseDto(
            $mapper->mapEntityToResponseDto(
                $entity,
                $responseDtoFqcn,
            ),
        );
    }
}
