<?php

declare(strict_types=1);

namespace NoahVet\Reef\Business\Enumerator;

use NoahVet\Reef\Business\Model\Factory\GroupWithTeamFactory;
use NoahVet\Reef\Business\Model\GroupWithTeam;

class GroupWithTeamEnumerator
{
    public function __construct(
        protected VeterinaryGroupEnumerator $groupEnumerator,
        protected GroupWithTeamFactory $groupWithTeamFactory,
    ) {
    }

    /**
     * @return \Generator<GroupWithTeam>
     */
    public function enumerateAll(int $groupBatchSize = 50): \Generator
    {
        $groups = [];

        foreach ($this->groupEnumerator->enumerateAll([], $groupBatchSize) as $group) {
            $groups[] = $group;

            if (\count($groups) === $groupBatchSize) {
                foreach ($this->groupWithTeamFactory->createBatch($groups) as $item) {
                    yield $item;
                }
                $groups = [];
            }
        }

        if (!empty($groups)) {
            foreach ($this->groupWithTeamFactory->createBatch($groups) as $item) {
                yield $item;
            }
        }
    }
}
