<?php

declare(strict_types=1);

namespace NoahVet\Reef\Business\Enumerator\Factory;

use NoahVet\Reef\Business\Enumerator\EstablishmentWithTeamEnumerator;
use NoahVet\Reef\Business\Model\Factory\EstablishmentWithTeamFactory;
use NoahVet\Reef\Business\Model\Factory\TeamMemberFactory;
use NoahVet\Reef\Jane\Client;

class EstablishmentWithTeamEnumeratorFactory
{
    public function __construct(
        private VeterinaryEstablishmentEnumeratorFactory $establishmentEnumeratorFactory,
        private VeterinaryEstablishmentTeamMembersEnumeratorFactory $establishmentTeamMembersEnumeratorFactory,
        private TeamMemberFactory $teamMemberFactory,
    ) {
    }

    public function create(Client $client): EstablishmentWithTeamEnumerator
    {
        return new EstablishmentWithTeamEnumerator(
            $this->establishmentEnumeratorFactory->create($client),
            new EstablishmentWithTeamFactory(
                $this->establishmentTeamMembersEnumeratorFactory->create($client),
                $this->teamMemberFactory,
            ),
        );
    }
}
