<?php

declare(strict_types=1);

namespace NoahVet\Jane\Component\OpenApi3;

use Jane\Component\JsonSchema\Generator\Naming;
use Jane\Component\JsonSchema\Generator\ValidatorGenerator;
use Jane\Component\OpenApi3\Generator\EndpointGenerator;
use Jane\Component\OpenApi3\Generator\GeneratorFactory;
use Jane\Component\OpenApiCommon\Generator\AuthenticationGenerator;
use Jane\Component\OpenApiCommon\Generator\ModelGenerator;
use Jane\Component\OpenApiCommon\Generator\NormalizerGenerator;
use NoahVet\Jane\Component\OpenApiCommon\Generator\RuntimeGenerator;
use PhpParser\ParserFactory;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;

class JaneOpenApi extends \Jane\Component\OpenApi3\JaneOpenApi
{
    protected static function generators(DenormalizerInterface $denormalizer, array $options = []): \Generator
    {
        $naming = new Naming();
        $parser = (new ParserFactory())->create(ParserFactory::PREFER_PHP7);

        yield new ModelGenerator($naming, $parser);
        yield new NormalizerGenerator(
            $naming,
            $parser,
            $options['reference'] ?? false,
            $options['use-cacheable-supports-method'] ?? false,
            $options['skip-null-values'] ?? true,
            $options['skip-required-fields'] ?? false,
            $options['validation'] ?? false,
        );
        yield new AuthenticationGenerator();
        yield GeneratorFactory::build($denormalizer, $options['endpoint-generator'] ?: EndpointGenerator::class);
        yield new RuntimeGenerator($naming, $parser);
        if ($options['validation'] ?? false) {
            yield new ValidatorGenerator($naming);
        }
    }
}
