<?php

declare(strict_types=1);

namespace NoahVet\Reef\Test\A_Unit\Log\Formater;

use NoahVet\Reef\Domain\Log\SyslogMessage;
use NoahVet\Reef\Log\Formater\Rfc5424Formater;
use PHPUnit\Framework\TestCase;
use Symfony\Component\Clock\MockClock;

class Rfc5424FormaterTest extends TestCase
{
    public function testFormat(): void
    {
        $formater = new Rfc5424Formater(
            'reef:iam',
            new MockClock(new \DateTimeImmutable('2023-09-01 00:00:00')),
        );

        $message = new SyslogMessage();
        $message
            ->setEventType('service_authentication')
            ->setResourceType('reef:iam:principal')
            ->setResourceId('reef:iam:principal:8ff3fdbe-ffca-4c1b-80a5-ecfd55748940')
            ->setPrincipalId('reef:iam:principal:45c7e84e-991a-48e9-b0c5-2713909a4ddb')
            ->setAction('reef:iam:principal:perm:grant')
            ->setExtraData([
                'granted_permission' => 'reef:iam:principal:perm:edit',
                'granted_to' => 'reef:iam:principal:45c7e84e-991a-48e9-b0c5-2713909a4ddb',
            ])
        ;

        $message = $formater->format($message);

        $pid = '' == \getmypid() ? '-' : \getmypid();
        $hostname = \gethostname();
        $expectedLog = '<133>1 2023-09-01T00:00:00+02:00 '.$hostname.' reef:iam '.$pid.' - '
            .'[a action="reef:iam:principal:perm:grant" event_type="service_authentication"'
            .' principal_id="reef:iam:principal:45c7e84e-991a-48e9-b0c5-2713909a4ddb"'
            .' resource_type="reef:iam:principal"'
            .' resource_id="reef:iam:principal:8ff3fdbe-ffca-4c1b-80a5-ecfd55748940"]'
            .'[e granted_permission="reef:iam:principal:perm:edit"'
            .' granted_to="reef:iam:principal:45c7e84e-991a-48e9-b0c5-2713909a4ddb"]';

        self::assertEquals($expectedLog, $message);
    }
}
