<?php

declare(strict_types=1);

namespace NoahVet\Reef\Test\A_Unit\Jane\Endpoint;

use NoahVet\Reef\Jane\Endpoint\GetPrincipalItem;
use NoahVet\Reef\Jane\Model\PrincipalGet;
use NoahVet\Reef\Test\A_Unit\Jane\AbstractJaneTest;
use Psr\Http\Message\ResponseInterface;
use Psr\Http\Message\StreamInterface;

class GetPrincipalItemTest extends AbstractJaneTest
{
    public function testParseResponse(): void
    {
        $response = $this->getMockBuilder(ResponseInterface::class)
            ->disableOriginalConstructor()
            ->getMock()
        ;

        $response
            ->method('hasHeader')
            ->with('Content-Type')
            ->willReturn(true)
        ;
        $response
            ->method('getHeader')
            ->with('Content-Type')
            ->willReturn(['application/json; charset=utf-8'])
        ;
        $response
            ->method('getStatusCode')
            ->willReturn(200)
        ;

        $streamInterface = $this->createMock(StreamInterface::class);
        $streamInterface->method('__toString')
            ->willReturn(
                '{"id":"b0199a11-47aa-4553-975e-4228ebc9fb22","type":"person","email":"admin@admin.com",'
                .'"lastname":null,"firstname":null,"status":"enabled","lastLogin":null,"locale":"fr_FR",'
                .'"timezone":"Europe\/Paris","birthDate":null,"birthPostCode":null,"birthCity":null,'
                .'"birthCountry":null,"mainAddress":{"city":null,"country":null,"postalCode":null,'
                .'"streetName":null,"streetNumber":null,"email":null,"addressSupplement":null,"department":null,'
                .'"postBoxNumber":null,"recipientIdentity":null,"region":null,"phone":null},'
                .'"privacyPolicyAccepted":null,"phoneNumbers":[],"mainPhoneNumber":null,'
                .'"created":"2023-01-24T09:59:29+01:00","updated":"2023-01-24T09:59:29+01:00"}')
        ;

        $response
            ->method('getBody')
            ->willReturn($streamInterface)
        ;

        $endpoint = new GetPrincipalItem('b0199a11-47aa-4553-975e-4228ebc9fb22');
        $parsedResponse = $endpoint->parseResponse(
            $response,
            $this->getSerializer(),
        );

        self::assertInstanceOf(PrincipalGet::class, $parsedResponse);
        self::assertEquals('b0199a11-47aa-4553-975e-4228ebc9fb22', $parsedResponse->getId());
        self::assertEquals('admin@admin.com', $parsedResponse->getEmail());
        self::assertNull($parsedResponse->getFirstname());
        self::assertNull($parsedResponse->getLastname());
        self::assertEquals('enabled', $parsedResponse->getStatus());
        self::assertNull($parsedResponse->getBirthDate());
        self::assertEquals('fr_FR', $parsedResponse->getLocale());
        self::assertEquals('Europe/Paris', $parsedResponse->getTimezone());
        self::assertEquals(
            '2023-01-24T09:59:29+01:00',
            $parsedResponse->getCreated()->format(\DATE_ATOM),
        );
        self::assertEquals(
            '2023-01-24T09:59:29+01:00',
            $parsedResponse->getUpdated()->format(\DATE_ATOM),
        );
    }
}
