<?php

declare(strict_types=1);

namespace NoahVet\Reef\Security\IAM\Model;

class ResourceType implements \Stringable
{
    protected function __construct(
        protected string $slug,
    ) {
    }

    public function __toString(): string
    {
        return $this->slug;
    }

    public static function fromString(string $slug): self
    {
        return new self($slug);
    }

    public function getSlug(): string
    {
        return $this->slug;
    }

    public function getGroupSlug(): string
    {
        return $this->slug.'s';
    }
}
