<?php

declare(strict_types=1);

namespace NoahVet\Reef\RabbitMQ\Task\Sender;

use NoahVet\Reef\RabbitMQ\Producer\Factory\ReefMQProducerFactoryInterface;
use NoahVet\Reef\RabbitMQ\Task\InternalTaskInterface;

class ReefTaskSender implements ReefTaskSenderInterface
{
    public function __construct(
        private readonly ReefMQProducerFactoryInterface $producerFactory,
    ) {
    }

    public function sendTask(InternalTaskInterface $internalTask): void
    {
        $this->producerFactory->getProducer()->publishTask($internalTask);
    }
}
