<?php

declare(strict_types=1);

namespace NoahVet\Reef\RabbitMQ\Task\Factory;

use NoahVet\Reef\RabbitMQ\Task\ConsoleCommandTask;
use NoahVet\Reef\RabbitMQ\Task\InternalTaskInterface;
use Symfony\Component\Console\Command\Command;

class ConsoleCommandTaskFactory implements ConsoleCommandTaskFactoryInterface
{
    public function create(
        Command $command,
        array $arguments,
    ): InternalTaskInterface {
        return new ConsoleCommandTask($command, $arguments);
    }
}
