<?php

declare(strict_types=1);

namespace NoahVet\Reef\RabbitMQ;

use PhpAmqpLib\Channel\AMQPChannel;

trait InternalQueueTrait
{
    protected function declareQueue(AMQPChannel $channel, string $queueName): void
    {
        $channel->queue_declare(
            $queueName,
            false,
            true,
            false,
            false,
        );

        $channel->queue_bind($queueName, 'reef-notify');
    }
}
