<?php

declare(strict_types=1);

namespace NoahVet\Reef\Plugin\Cache\Model\Factory;

use NoahVet\Reef\Plugin\Cache\Model\CacheableResponse;
use Psr\Http\Message\ResponseInterface;

class CacheableResponseFactory
{
    public function create(ResponseInterface $response): CacheableResponse
    {
        return new CacheableResponse(
            $response->getProtocolVersion(),
            $response->getStatusCode(),
            $response->getReasonPhrase(),
            $response->getHeaders(),
            $response->getBody(),
        );
    }
}
