<?php

declare(strict_types=1);

namespace NoahVet\Reef\Phpunit\RabbitMQ\Producer;

use NoahVet\Reef\RabbitMQ\Notification\ReefNotificationInterface;
use NoahVet\Reef\RabbitMQ\Producer\ReefMQProducerInterface;
use NoahVet\Reef\RabbitMQ\Task\InternalTaskInterface;

class MockedMQProducer implements ReefMQProducerInterface
{
    /**
     * @var array<int, ReefNotificationInterface>
     */
    private array $notifications = [];

    /**
     * @var array<int, InternalTaskInterface>
     */
    private array $tasks = [];

    public function publishNotification(ReefNotificationInterface $notification): void
    {
        $this->notifications[] = $notification;
    }

    public function publishTask(InternalTaskInterface $task): void
    {
        $this->tasks[] = $task;
    }

    public function clear(): void
    {
        $this->notifications = [];
        $this->tasks = [];
    }

    /**
     * @return array<int, ReefNotificationInterface>
     */
    public function getNotifications(): array
    {
        return $this->notifications;
    }

    /**
     * @return array<int, InternalTaskInterface>
     */
    public function getTasks(): array
    {
        return $this->tasks;
    }
}
