<?php

declare(strict_types=1);

namespace NoahVet\Reef\Mapper\Common\Search;

use Doctrine\Common\Collections\Collection;

/**
 * @template EntityType of object
 * @template RequestDtoType of object
 * @template ResponseDtoType of object
 */
interface AbstractSearchMapperInterface
{
    /**
     * @param array<int, EntityType>        $data
     * @param class-string<ResponseDtoType> $responseDtoFqcn
     *
     * @return list<ResponseDtoType>
     */
    public function mapDataToResponseDto(
        array $data,
        string $responseDtoFqcn,
    ): mixed;

    /**
     * @param list<ResponseDtoType> $dtoAsArray
     *
     * @return list<mixed>
     */
    public function normalizeResponseDto(
        array $dtoAsArray,
    ): array;

    /**
     * @param Collection<int, EntityType> $entities
     *
     * @return list<mixed>
     */
    public function normalizeEntities(
        Collection $entities,
    ): array;

    /**
     * @param class-string<RequestDtoType> $requestDto
     *
     * @return RequestDtoType
     */
    public function mapDataToRequestDto(
        string $data,
        string $requestDto,
    ): object;
}
