<?php

declare(strict_types=1);

namespace NoahVet\Reef\Mapper\Common\One\Create;

use NoahVet\Reef\Domain\Tool\ArrayTool;
use NoahVet\Reef\Mapper\Common\One\AbstractOneMapper;
use Symfony\Component\Serializer\Normalizer\AbstractNormalizer;

/**
 * @template EntityType of object
 * @template RequestDtoType of object
 * @template ResponseDtoType of object
 *
 * @extends AbstractOneMapper<EntityType>
 *
 * @implements AbstractCreateMapperInterface<EntityType, RequestDtoType, ResponseDtoType>
 */
abstract class AbstractCreateMapper extends AbstractOneMapper implements AbstractCreateMapperInterface
{
    /**
     * @param class-string<RequestDtoType> $requestDto
     *
     * @return RequestDtoType
     */
    public function mapDataToRequestDto(
        string $data,
        string $requestDto,
    ): object {
        /** @var array<string, mixed> $dataAsArray */
        $dataAsArray = $this->serializer->decode(
            $data,
            'json',
        );

        ArrayTool::applyTrimRecursive($dataAsArray);

        return $this->serializer->denormalize(
            $dataAsArray,
            $requestDto,
            'json',
            [
                AbstractNormalizer::ALLOW_EXTRA_ATTRIBUTES => false,
            ],
        );
    }
}
