<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Runtime\Normalizer;

use Symfony\Component\Validator\Constraint;
use Symfony\Component\Validator\Validation;

trait ValidatorTrait
{
    protected function validate(array $data, Constraint $constraint): void
    {
        $validator = Validation::createValidator();
        $violations = $validator->validate($data, $constraint);
        if (0 < $violations->count()) {
            throw new ValidationException($violations);
        }
    }
}
