<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Jane\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Jane\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;

class WebOrderDiscountResponseNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use CheckArray;
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use ValidatorTrait;

    public function supportsDenormalization(mixed $data, string $type, ?string $format = null, array $context = []): bool
    {
        return \NoahVet\Reef\Jane\Model\WebOrderDiscountResponse::class === $type;
    }

    public function supportsNormalization(mixed $data, ?string $format = null, array $context = []): bool
    {
        return \is_object($data) && \NoahVet\Reef\Jane\Model\WebOrderDiscountResponse::class === $data::class;
    }

    public function denormalize(mixed $data, string $type, ?string $format = null, array $context = []): mixed
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Jane\Model\WebOrderDiscountResponse();
        if (\array_key_exists('amount', $data) && \is_int($data['amount'])) {
            $data['amount'] = (float) $data['amount'];
        }
        if (\array_key_exists('valuedAmount', $data) && \is_int($data['valuedAmount'])) {
            $data['valuedAmount'] = (float) $data['valuedAmount'];
        }
        if (\array_key_exists('paying', $data) && \is_int($data['paying'])) {
            $data['paying'] = (float) $data['paying'];
        }
        if (\array_key_exists('yearEndDiscount', $data) && \is_int($data['yearEndDiscount'])) {
            $data['yearEndDiscount'] = (float) $data['yearEndDiscount'];
        }
        if (\array_key_exists('payRate', $data) && \is_int($data['payRate'])) {
            $data['payRate'] = (float) $data['payRate'];
        }
        if (\array_key_exists('yearEndDiscountRate', $data) && \is_int($data['yearEndDiscountRate'])) {
            $data['yearEndDiscountRate'] = (float) $data['yearEndDiscountRate'];
        }
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('id', $data)) {
            $object->setId($data['id']);
            unset($data['id']);
        }
        if (\array_key_exists('mvsId', $data)) {
            $object->setMvsId($data['mvsId']);
            unset($data['mvsId']);
        }
        if (\array_key_exists('code', $data)) {
            $object->setCode($data['code']);
            unset($data['code']);
        }
        if (\array_key_exists('name', $data)) {
            $object->setName($data['name']);
            unset($data['name']);
        }
        if (\array_key_exists('type', $data)) {
            $object->setType($data['type']);
            unset($data['type']);
        }
        if (\array_key_exists('amount', $data)) {
            $object->setAmount($data['amount']);
            unset($data['amount']);
        }
        if (\array_key_exists('valuedAmount', $data)) {
            $object->setValuedAmount($data['valuedAmount']);
            unset($data['valuedAmount']);
        }
        if (\array_key_exists('paying', $data)) {
            $object->setPaying($data['paying']);
            unset($data['paying']);
        }
        if (\array_key_exists('yearEndDiscount', $data)) {
            $object->setYearEndDiscount($data['yearEndDiscount']);
            unset($data['yearEndDiscount']);
        }
        if (\array_key_exists('payRate', $data)) {
            $object->setPayRate($data['payRate']);
            unset($data['payRate']);
        }
        if (\array_key_exists('yearEndDiscountRate', $data)) {
            $object->setYearEndDiscountRate($data['yearEndDiscountRate']);
            unset($data['yearEndDiscountRate']);
        }
        foreach ($data as $key => $value) {
            if (\preg_match('/.*/', (string) $key)) {
                $object[$key] = $value;
            }
        }

        return $object;
    }

    public function normalize(mixed $data, ?string $format = null, array $context = []): array|string|int|float|bool|\ArrayObject|null
    {
        $dataArray = [];
        if ($data->isInitialized('id') && null !== $data->getId()) {
            $dataArray['id'] = $data->getId();
        }
        if ($data->isInitialized('mvsId') && null !== $data->getMvsId()) {
            $dataArray['mvsId'] = $data->getMvsId();
        }
        if ($data->isInitialized('code') && null !== $data->getCode()) {
            $dataArray['code'] = $data->getCode();
        }
        if ($data->isInitialized('name') && null !== $data->getName()) {
            $dataArray['name'] = $data->getName();
        }
        if ($data->isInitialized('type') && null !== $data->getType()) {
            $dataArray['type'] = $data->getType();
        }
        if ($data->isInitialized('amount') && null !== $data->getAmount()) {
            $dataArray['amount'] = $data->getAmount();
        }
        if ($data->isInitialized('valuedAmount') && null !== $data->getValuedAmount()) {
            $dataArray['valuedAmount'] = $data->getValuedAmount();
        }
        if ($data->isInitialized('paying') && null !== $data->getPaying()) {
            $dataArray['paying'] = $data->getPaying();
        }
        if ($data->isInitialized('yearEndDiscount') && null !== $data->getYearEndDiscount()) {
            $dataArray['yearEndDiscount'] = $data->getYearEndDiscount();
        }
        if ($data->isInitialized('payRate') && null !== $data->getPayRate()) {
            $dataArray['payRate'] = $data->getPayRate();
        }
        if ($data->isInitialized('yearEndDiscountRate') && null !== $data->getYearEndDiscountRate()) {
            $dataArray['yearEndDiscountRate'] = $data->getYearEndDiscountRate();
        }
        foreach ($data as $key => $value) {
            if (\preg_match('/.*/', (string) $key)) {
                $dataArray[$key] = $value;
            }
        }

        return $dataArray;
    }

    public function getSupportedTypes(?string $format = null): array
    {
        return [\NoahVet\Reef\Jane\Model\WebOrderDiscountResponse::class => false];
    }
}
