<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Jane\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Jane\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;

class VeterinaryEstablishmentRequestScheduleNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use CheckArray;
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use ValidatorTrait;

    public function supportsDenormalization(mixed $data, string $type, ?string $format = null, array $context = []): bool
    {
        return \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentRequestSchedule::class === $type;
    }

    public function supportsNormalization(mixed $data, ?string $format = null, array $context = []): bool
    {
        return \is_object($data) && \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentRequestSchedule::class === $data::class;
    }

    public function denormalize(mixed $data, string $type, ?string $format = null, array $context = []): mixed
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentRequestSchedule();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('monday', $data) && null !== $data['monday']) {
            $values = [];
            foreach ($data['monday'] as $value) {
                $values[] = $this->denormalizer->denormalize($value, \NoahVet\Reef\Jane\Model\OpeningPeriodRequest::class, 'json', $context);
            }
            $object->setMonday($values);
            unset($data['monday']);
        } elseif (\array_key_exists('monday', $data) && null === $data['monday']) {
            $object->setMonday(null);
        }
        if (\array_key_exists('tuesday', $data) && null !== $data['tuesday']) {
            $values_1 = [];
            foreach ($data['tuesday'] as $value_1) {
                $values_1[] = $this->denormalizer->denormalize($value_1, \NoahVet\Reef\Jane\Model\OpeningPeriodRequest::class, 'json', $context);
            }
            $object->setTuesday($values_1);
            unset($data['tuesday']);
        } elseif (\array_key_exists('tuesday', $data) && null === $data['tuesday']) {
            $object->setTuesday(null);
        }
        if (\array_key_exists('wednesday', $data) && null !== $data['wednesday']) {
            $values_2 = [];
            foreach ($data['wednesday'] as $value_2) {
                $values_2[] = $this->denormalizer->denormalize($value_2, \NoahVet\Reef\Jane\Model\OpeningPeriodRequest::class, 'json', $context);
            }
            $object->setWednesday($values_2);
            unset($data['wednesday']);
        } elseif (\array_key_exists('wednesday', $data) && null === $data['wednesday']) {
            $object->setWednesday(null);
        }
        if (\array_key_exists('thursday', $data) && null !== $data['thursday']) {
            $values_3 = [];
            foreach ($data['thursday'] as $value_3) {
                $values_3[] = $this->denormalizer->denormalize($value_3, \NoahVet\Reef\Jane\Model\OpeningPeriodRequest::class, 'json', $context);
            }
            $object->setThursday($values_3);
            unset($data['thursday']);
        } elseif (\array_key_exists('thursday', $data) && null === $data['thursday']) {
            $object->setThursday(null);
        }
        if (\array_key_exists('friday', $data) && null !== $data['friday']) {
            $values_4 = [];
            foreach ($data['friday'] as $value_4) {
                $values_4[] = $this->denormalizer->denormalize($value_4, \NoahVet\Reef\Jane\Model\OpeningPeriodRequest::class, 'json', $context);
            }
            $object->setFriday($values_4);
            unset($data['friday']);
        } elseif (\array_key_exists('friday', $data) && null === $data['friday']) {
            $object->setFriday(null);
        }
        if (\array_key_exists('saturday', $data) && null !== $data['saturday']) {
            $values_5 = [];
            foreach ($data['saturday'] as $value_5) {
                $values_5[] = $this->denormalizer->denormalize($value_5, \NoahVet\Reef\Jane\Model\OpeningPeriodRequest::class, 'json', $context);
            }
            $object->setSaturday($values_5);
            unset($data['saturday']);
        } elseif (\array_key_exists('saturday', $data) && null === $data['saturday']) {
            $object->setSaturday(null);
        }
        if (\array_key_exists('sunday', $data) && null !== $data['sunday']) {
            $values_6 = [];
            foreach ($data['sunday'] as $value_6) {
                $values_6[] = $this->denormalizer->denormalize($value_6, \NoahVet\Reef\Jane\Model\OpeningPeriodRequest::class, 'json', $context);
            }
            $object->setSunday($values_6);
            unset($data['sunday']);
        } elseif (\array_key_exists('sunday', $data) && null === $data['sunday']) {
            $object->setSunday(null);
        }
        foreach ($data as $key => $value_7) {
            if (\preg_match('/.*/', (string) $key)) {
                $object[$key] = $value_7;
            }
        }

        return $object;
    }

    public function normalize(mixed $data, ?string $format = null, array $context = []): array|string|int|float|bool|\ArrayObject|null
    {
        $dataArray = [];
        $values = [];
        foreach ($data->getMonday() as $value) {
            $values[] = $this->normalizer->normalize($value, 'json', $context);
        }
        $dataArray['monday'] = $values;
        $values_1 = [];
        foreach ($data->getTuesday() as $value_1) {
            $values_1[] = $this->normalizer->normalize($value_1, 'json', $context);
        }
        $dataArray['tuesday'] = $values_1;
        $values_2 = [];
        foreach ($data->getWednesday() as $value_2) {
            $values_2[] = $this->normalizer->normalize($value_2, 'json', $context);
        }
        $dataArray['wednesday'] = $values_2;
        $values_3 = [];
        foreach ($data->getThursday() as $value_3) {
            $values_3[] = $this->normalizer->normalize($value_3, 'json', $context);
        }
        $dataArray['thursday'] = $values_3;
        $values_4 = [];
        foreach ($data->getFriday() as $value_4) {
            $values_4[] = $this->normalizer->normalize($value_4, 'json', $context);
        }
        $dataArray['friday'] = $values_4;
        $values_5 = [];
        foreach ($data->getSaturday() as $value_5) {
            $values_5[] = $this->normalizer->normalize($value_5, 'json', $context);
        }
        $dataArray['saturday'] = $values_5;
        $values_6 = [];
        foreach ($data->getSunday() as $value_6) {
            $values_6[] = $this->normalizer->normalize($value_6, 'json', $context);
        }
        $dataArray['sunday'] = $values_6;
        foreach ($data as $key => $value_7) {
            if (\preg_match('/.*/', (string) $key)) {
                $dataArray[$key] = $value_7;
            }
        }

        return $dataArray;
    }

    public function getSupportedTypes(?string $format = null): array
    {
        return [\NoahVet\Reef\Jane\Model\VeterinaryEstablishmentRequestSchedule::class => false];
    }
}
