<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Jane\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Jane\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;

class VeterinaryEstablishmentAddressRequestNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use CheckArray;
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use ValidatorTrait;

    public function supportsDenormalization(mixed $data, string $type, ?string $format = null, array $context = []): bool
    {
        return \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentAddressRequest::class === $type;
    }

    public function supportsNormalization(mixed $data, ?string $format = null, array $context = []): bool
    {
        return \is_object($data) && \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentAddressRequest::class === $data::class;
    }

    public function denormalize(mixed $data, string $type, ?string $format = null, array $context = []): mixed
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentAddressRequest();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('addressSupplement', $data) && null !== $data['addressSupplement']) {
            $object->setAddressSupplement($data['addressSupplement']);
            unset($data['addressSupplement']);
        } elseif (\array_key_exists('addressSupplement', $data) && null === $data['addressSupplement']) {
            $object->setAddressSupplement(null);
        }
        if (\array_key_exists('city', $data)) {
            $object->setCity($data['city']);
            unset($data['city']);
        }
        if (\array_key_exists('country', $data)) {
            $object->setCountry($data['country']);
            unset($data['country']);
        }
        if (\array_key_exists('coordinates', $data) && null !== $data['coordinates']) {
            $object->setCoordinates($this->denormalizer->denormalize($data['coordinates'], \NoahVet\Reef\Jane\Model\CoordinateRequest::class, 'json', $context));
            unset($data['coordinates']);
        } elseif (\array_key_exists('coordinates', $data) && null === $data['coordinates']) {
            $object->setCoordinates(null);
        }
        if (\array_key_exists('department', $data) && null !== $data['department']) {
            $object->setDepartment($data['department']);
            unset($data['department']);
        } elseif (\array_key_exists('department', $data) && null === $data['department']) {
            $object->setDepartment(null);
        }
        if (\array_key_exists('email', $data) && null !== $data['email']) {
            $object->setEmail($data['email']);
            unset($data['email']);
        } elseif (\array_key_exists('email', $data) && null === $data['email']) {
            $object->setEmail(null);
        }
        if (\array_key_exists('entitled', $data)) {
            $object->setEntitled($data['entitled']);
            unset($data['entitled']);
        }
        if (\array_key_exists('phone', $data) && null !== $data['phone']) {
            $object->setPhone($this->denormalizer->denormalize($data['phone'], \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentAddressRequestPhone::class, 'json', $context));
            unset($data['phone']);
        } elseif (\array_key_exists('phone', $data) && null === $data['phone']) {
            $object->setPhone(null);
        }
        if (\array_key_exists('postalCode', $data)) {
            $object->setPostalCode($data['postalCode']);
            unset($data['postalCode']);
        }
        if (\array_key_exists('postBoxNumber', $data) && null !== $data['postBoxNumber']) {
            $object->setPostBoxNumber($data['postBoxNumber']);
            unset($data['postBoxNumber']);
        } elseif (\array_key_exists('postBoxNumber', $data) && null === $data['postBoxNumber']) {
            $object->setPostBoxNumber(null);
        }
        if (\array_key_exists('recipientIdentity', $data) && null !== $data['recipientIdentity']) {
            $object->setRecipientIdentity($data['recipientIdentity']);
            unset($data['recipientIdentity']);
        } elseif (\array_key_exists('recipientIdentity', $data) && null === $data['recipientIdentity']) {
            $object->setRecipientIdentity(null);
        }
        if (\array_key_exists('region', $data) && null !== $data['region']) {
            $object->setRegion($data['region']);
            unset($data['region']);
        } elseif (\array_key_exists('region', $data) && null === $data['region']) {
            $object->setRegion(null);
        }
        if (\array_key_exists('streetName', $data)) {
            $object->setStreetName($data['streetName']);
            unset($data['streetName']);
        }
        if (\array_key_exists('streetNumber', $data) && null !== $data['streetNumber']) {
            $object->setStreetNumber($data['streetNumber']);
            unset($data['streetNumber']);
        } elseif (\array_key_exists('streetNumber', $data) && null === $data['streetNumber']) {
            $object->setStreetNumber(null);
        }
        if (\array_key_exists('veterinaryEstablishment', $data)) {
            $object->setVeterinaryEstablishment($this->denormalizer->denormalize($data['veterinaryEstablishment'], \NoahVet\Reef\Jane\Model\IdRequest::class, 'json', $context));
            unset($data['veterinaryEstablishment']);
        }
        if (\array_key_exists('websiteUrl', $data) && null !== $data['websiteUrl']) {
            $object->setWebsiteUrl($data['websiteUrl']);
            unset($data['websiteUrl']);
        } elseif (\array_key_exists('websiteUrl', $data) && null === $data['websiteUrl']) {
            $object->setWebsiteUrl(null);
        }
        foreach ($data as $key => $value) {
            if (\preg_match('/.*/', (string) $key)) {
                $object[$key] = $value;
            }
        }

        return $object;
    }

    public function normalize(mixed $data, ?string $format = null, array $context = []): array|string|int|float|bool|\ArrayObject|null
    {
        $dataArray = [];
        if ($data->isInitialized('addressSupplement') && null !== $data->getAddressSupplement()) {
            $dataArray['addressSupplement'] = $data->getAddressSupplement();
        }
        $dataArray['city'] = $data->getCity();
        $dataArray['country'] = $data->getCountry();
        if ($data->isInitialized('coordinates') && null !== $data->getCoordinates()) {
            $dataArray['coordinates'] = $this->normalizer->normalize($data->getCoordinates(), 'json', $context);
        }
        if ($data->isInitialized('department') && null !== $data->getDepartment()) {
            $dataArray['department'] = $data->getDepartment();
        }
        if ($data->isInitialized('email') && null !== $data->getEmail()) {
            $dataArray['email'] = $data->getEmail();
        }
        $dataArray['entitled'] = $data->getEntitled();
        if ($data->isInitialized('phone') && null !== $data->getPhone()) {
            $dataArray['phone'] = $this->normalizer->normalize($data->getPhone(), 'json', $context);
        }
        $dataArray['postalCode'] = $data->getPostalCode();
        if ($data->isInitialized('postBoxNumber') && null !== $data->getPostBoxNumber()) {
            $dataArray['postBoxNumber'] = $data->getPostBoxNumber();
        }
        if ($data->isInitialized('recipientIdentity') && null !== $data->getRecipientIdentity()) {
            $dataArray['recipientIdentity'] = $data->getRecipientIdentity();
        }
        if ($data->isInitialized('region') && null !== $data->getRegion()) {
            $dataArray['region'] = $data->getRegion();
        }
        $dataArray['streetName'] = $data->getStreetName();
        if ($data->isInitialized('streetNumber') && null !== $data->getStreetNumber()) {
            $dataArray['streetNumber'] = $data->getStreetNumber();
        }
        $dataArray['veterinaryEstablishment'] = $this->normalizer->normalize($data->getVeterinaryEstablishment(), 'json', $context);
        if ($data->isInitialized('websiteUrl') && null !== $data->getWebsiteUrl()) {
            $dataArray['websiteUrl'] = $data->getWebsiteUrl();
        }
        foreach ($data as $key => $value) {
            if (\preg_match('/.*/', (string) $key)) {
                $dataArray[$key] = $value;
            }
        }

        return $dataArray;
    }

    public function getSupportedTypes(?string $format = null): array
    {
        return [\NoahVet\Reef\Jane\Model\VeterinaryEstablishmentAddressRequest::class => false];
    }
}
