<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Jane\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Jane\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;

class V1PetsGetResponse200ItemNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use CheckArray;
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use ValidatorTrait;

    public function supportsDenormalization(mixed $data, string $type, ?string $format = null, array $context = []): bool
    {
        return \NoahVet\Reef\Jane\Model\V1PetsGetResponse200Item::class === $type;
    }

    public function supportsNormalization(mixed $data, ?string $format = null, array $context = []): bool
    {
        return \is_object($data) && \NoahVet\Reef\Jane\Model\V1PetsGetResponse200Item::class === $data::class;
    }

    public function denormalize(mixed $data, string $type, ?string $format = null, array $context = []): mixed
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Jane\Model\V1PetsGetResponse200Item();
        if (\array_key_exists('isAnonymous', $data) && \is_int($data['isAnonymous'])) {
            $data['isAnonymous'] = (bool) $data['isAnonymous'];
        }
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('id', $data)) {
            $object->setId($data['id']);
            unset($data['id']);
        }
        if (\array_key_exists('createdDate', $data)) {
            $object->setCreatedDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['createdDate']));
            unset($data['createdDate']);
        }
        if (\array_key_exists('updatedDate', $data)) {
            $object->setUpdatedDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['updatedDate']));
            unset($data['updatedDate']);
        }
        if (\array_key_exists('code', $data)) {
            $object->setCode($data['code']);
            unset($data['code']);
        }
        if (\array_key_exists('isAnonymous', $data)) {
            $object->setIsAnonymous($data['isAnonymous']);
            unset($data['isAnonymous']);
        }
        if (\array_key_exists('microchips', $data)) {
            $values = [];
            foreach ($data['microchips'] as $value) {
                $values[] = $this->denormalizer->denormalize($value, \NoahVet\Reef\Jane\Model\V1PetsGetResponse200ItemMicrochipsItem::class, 'json', $context);
            }
            $object->setMicrochips($values);
            unset($data['microchips']);
        }
        if (\array_key_exists('name', $data) && null !== $data['name']) {
            $object->setName($data['name']);
            unset($data['name']);
        } elseif (\array_key_exists('name', $data) && null === $data['name']) {
            $object->setName(null);
        }
        if (\array_key_exists('passportNumber', $data) && null !== $data['passportNumber']) {
            $object->setPassportNumber($data['passportNumber']);
            unset($data['passportNumber']);
        } elseif (\array_key_exists('passportNumber', $data) && null === $data['passportNumber']) {
            $object->setPassportNumber(null);
        }
        if (\array_key_exists('tattoo', $data) && null !== $data['tattoo']) {
            $object->setTattoo($this->denormalizer->denormalize($data['tattoo'], \NoahVet\Reef\Jane\Model\V1PetsGetResponse200ItemTattoo::class, 'json', $context));
            unset($data['tattoo']);
        } elseif (\array_key_exists('tattoo', $data) && null === $data['tattoo']) {
            $object->setTattoo(null);
        }
        if (\array_key_exists('specie', $data)) {
            $object->setSpecie($this->denormalizer->denormalize($data['specie'], \NoahVet\Reef\Jane\Model\V1PetsGetResponse200ItemSpecie::class, 'json', $context));
            unset($data['specie']);
        }
        foreach ($data as $key => $value_1) {
            if (\preg_match('/.*/', (string) $key)) {
                $object[$key] = $value_1;
            }
        }

        return $object;
    }

    public function normalize(mixed $data, ?string $format = null, array $context = []): array|string|int|float|bool|\ArrayObject|null
    {
        $dataArray = [];
        $dataArray['id'] = $data->getId();
        $dataArray['createdDate'] = $data->getCreatedDate()?->format('Y-m-d\\TH:i:sP');
        $dataArray['updatedDate'] = $data->getUpdatedDate()?->format('Y-m-d\\TH:i:sP');
        $dataArray['code'] = $data->getCode();
        $dataArray['isAnonymous'] = $data->getIsAnonymous();
        $values = [];
        foreach ($data->getMicrochips() as $value) {
            $values[] = $this->normalizer->normalize($value, 'json', $context);
        }
        $dataArray['microchips'] = $values;
        $dataArray['name'] = $data->getName();
        $dataArray['passportNumber'] = $data->getPassportNumber();
        $dataArray['tattoo'] = $this->normalizer->normalize($data->getTattoo(), 'json', $context);
        $dataArray['specie'] = $this->normalizer->normalize($data->getSpecie(), 'json', $context);
        foreach ($data as $key => $value_1) {
            if (\preg_match('/.*/', (string) $key)) {
                $dataArray[$key] = $value_1;
            }
        }

        return $dataArray;
    }

    public function getSupportedTypes(?string $format = null): array
    {
        return [\NoahVet\Reef\Jane\Model\V1PetsGetResponse200Item::class => false];
    }
}
