<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Jane\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Jane\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;

class V1ContactsGetResponse206ItemNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use CheckArray;
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use ValidatorTrait;

    public function supportsDenormalization(mixed $data, string $type, ?string $format = null, array $context = []): bool
    {
        return \NoahVet\Reef\Jane\Model\V1ContactsGetResponse206Item::class === $type;
    }

    public function supportsNormalization(mixed $data, ?string $format = null, array $context = []): bool
    {
        return \is_object($data) && \NoahVet\Reef\Jane\Model\V1ContactsGetResponse206Item::class === $data::class;
    }

    public function denormalize(mixed $data, string $type, ?string $format = null, array $context = []): mixed
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Jane\Model\V1ContactsGetResponse206Item();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('id', $data)) {
            $object->setId($data['id']);
            unset($data['id']);
        }
        if (\array_key_exists('createdDate', $data)) {
            $object->setCreatedDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['createdDate']));
            unset($data['createdDate']);
        }
        if (\array_key_exists('updatedDate', $data)) {
            $object->setUpdatedDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['updatedDate']));
            unset($data['updatedDate']);
        }
        if (\array_key_exists('addressSupplement', $data) && null !== $data['addressSupplement']) {
            $object->setAddressSupplement($data['addressSupplement']);
            unset($data['addressSupplement']);
        } elseif (\array_key_exists('addressSupplement', $data) && null === $data['addressSupplement']) {
            $object->setAddressSupplement(null);
        }
        if (\array_key_exists('city', $data) && null !== $data['city']) {
            $object->setCity($data['city']);
            unset($data['city']);
        } elseif (\array_key_exists('city', $data) && null === $data['city']) {
            $object->setCity(null);
        }
        if (\array_key_exists('comment', $data) && null !== $data['comment']) {
            $object->setComment($data['comment']);
            unset($data['comment']);
        } elseif (\array_key_exists('comment', $data) && null === $data['comment']) {
            $object->setComment(null);
        }
        if (\array_key_exists('companyDetail', $data) && null !== $data['companyDetail']) {
            $object->setCompanyDetail($this->denormalizer->denormalize($data['companyDetail'], \NoahVet\Reef\Jane\Model\V1ContactsGetResponse206ItemCompanyDetail::class, 'json', $context));
            unset($data['companyDetail']);
        } elseif (\array_key_exists('companyDetail', $data) && null === $data['companyDetail']) {
            $object->setCompanyDetail(null);
        }
        if (\array_key_exists('country', $data)) {
            $object->setCountry($data['country']);
            unset($data['country']);
        }
        if (\array_key_exists('customerProfile', $data)) {
            $object->setCustomerProfile($this->denormalizer->denormalize($data['customerProfile'], \NoahVet\Reef\Jane\Model\V1ContactsGetResponse206ItemCustomerProfile::class, 'json', $context));
            unset($data['customerProfile']);
        }
        if (\array_key_exists('department', $data) && null !== $data['department']) {
            $object->setDepartment($data['department']);
            unset($data['department']);
        } elseif (\array_key_exists('department', $data) && null === $data['department']) {
            $object->setDepartment(null);
        }
        if (\array_key_exists('email', $data) && null !== $data['email']) {
            $object->setEmail($data['email']);
            unset($data['email']);
        } elseif (\array_key_exists('email', $data) && null === $data['email']) {
            $object->setEmail(null);
        }
        if (\array_key_exists('entitled', $data)) {
            $object->setEntitled($data['entitled']);
            unset($data['entitled']);
        }
        if (\array_key_exists('geolocation', $data) && null !== $data['geolocation']) {
            $object->setGeolocation($this->denormalizer->denormalize($data['geolocation'], \NoahVet\Reef\Jane\Model\V1ContactsGetResponse206ItemGeolocation::class, 'json', $context));
            unset($data['geolocation']);
        } elseif (\array_key_exists('geolocation', $data) && null === $data['geolocation']) {
            $object->setGeolocation(null);
        }
        if (\array_key_exists('phoneNumber', $data) && null !== $data['phoneNumber']) {
            $object->setPhoneNumber($data['phoneNumber']);
            unset($data['phoneNumber']);
        } elseif (\array_key_exists('phoneNumber', $data) && null === $data['phoneNumber']) {
            $object->setPhoneNumber(null);
        }
        if (\array_key_exists('postalCode', $data) && null !== $data['postalCode']) {
            $object->setPostalCode($data['postalCode']);
            unset($data['postalCode']);
        } elseif (\array_key_exists('postalCode', $data) && null === $data['postalCode']) {
            $object->setPostalCode(null);
        }
        if (\array_key_exists('postBoxNumber', $data) && null !== $data['postBoxNumber']) {
            $object->setPostBoxNumber($data['postBoxNumber']);
            unset($data['postBoxNumber']);
        } elseif (\array_key_exists('postBoxNumber', $data) && null === $data['postBoxNumber']) {
            $object->setPostBoxNumber(null);
        }
        if (\array_key_exists('recipientIdentity', $data) && null !== $data['recipientIdentity']) {
            $object->setRecipientIdentity($data['recipientIdentity']);
            unset($data['recipientIdentity']);
        } elseif (\array_key_exists('recipientIdentity', $data) && null === $data['recipientIdentity']) {
            $object->setRecipientIdentity(null);
        }
        if (\array_key_exists('region', $data) && null !== $data['region']) {
            $object->setRegion($data['region']);
            unset($data['region']);
        } elseif (\array_key_exists('region', $data) && null === $data['region']) {
            $object->setRegion(null);
        }
        if (\array_key_exists('streetName', $data) && null !== $data['streetName']) {
            $object->setStreetName($data['streetName']);
            unset($data['streetName']);
        } elseif (\array_key_exists('streetName', $data) && null === $data['streetName']) {
            $object->setStreetName(null);
        }
        if (\array_key_exists('streetNumber', $data) && null !== $data['streetNumber']) {
            $object->setStreetNumber($data['streetNumber']);
            unset($data['streetNumber']);
        } elseif (\array_key_exists('streetNumber', $data) && null === $data['streetNumber']) {
            $object->setStreetNumber(null);
        }
        if (\array_key_exists('type', $data) && null !== $data['type']) {
            $object->setType($data['type']);
            unset($data['type']);
        } elseif (\array_key_exists('type', $data) && null === $data['type']) {
            $object->setType(null);
        }
        foreach ($data as $key => $value) {
            if (\preg_match('/.*/', (string) $key)) {
                $object[$key] = $value;
            }
        }

        return $object;
    }

    public function normalize(mixed $data, ?string $format = null, array $context = []): array|string|int|float|bool|\ArrayObject|null
    {
        $dataArray = [];
        $dataArray['id'] = $data->getId();
        $dataArray['createdDate'] = $data->getCreatedDate()?->format('Y-m-d\\TH:i:sP');
        $dataArray['updatedDate'] = $data->getUpdatedDate()?->format('Y-m-d\\TH:i:sP');
        $dataArray['addressSupplement'] = $data->getAddressSupplement();
        $dataArray['city'] = $data->getCity();
        $dataArray['comment'] = $data->getComment();
        $dataArray['companyDetail'] = $this->normalizer->normalize($data->getCompanyDetail(), 'json', $context);
        $dataArray['country'] = $data->getCountry();
        $dataArray['customerProfile'] = $this->normalizer->normalize($data->getCustomerProfile(), 'json', $context);
        $dataArray['department'] = $data->getDepartment();
        $dataArray['email'] = $data->getEmail();
        $dataArray['entitled'] = $data->getEntitled();
        $dataArray['geolocation'] = $this->normalizer->normalize($data->getGeolocation(), 'json', $context);
        $dataArray['phoneNumber'] = $data->getPhoneNumber();
        $dataArray['postalCode'] = $data->getPostalCode();
        $dataArray['postBoxNumber'] = $data->getPostBoxNumber();
        $dataArray['recipientIdentity'] = $data->getRecipientIdentity();
        $dataArray['region'] = $data->getRegion();
        $dataArray['streetName'] = $data->getStreetName();
        $dataArray['streetNumber'] = $data->getStreetNumber();
        $dataArray['type'] = $data->getType();
        foreach ($data as $key => $value) {
            if (\preg_match('/.*/', (string) $key)) {
                $dataArray[$key] = $value;
            }
        }

        return $dataArray;
    }

    public function getSupportedTypes(?string $format = null): array
    {
        return [\NoahVet\Reef\Jane\Model\V1ContactsGetResponse206Item::class => false];
    }
}
