<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Jane\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Jane\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;

class PrincipalNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use CheckArray;
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use ValidatorTrait;

    public function supportsDenormalization(mixed $data, string $type, ?string $format = null, array $context = []): bool
    {
        return \NoahVet\Reef\Jane\Model\Principal::class === $type;
    }

    public function supportsNormalization(mixed $data, ?string $format = null, array $context = []): bool
    {
        return \is_object($data) && \NoahVet\Reef\Jane\Model\Principal::class === $data::class;
    }

    public function denormalize(mixed $data, string $type, ?string $format = null, array $context = []): mixed
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Jane\Model\Principal();
        if (\array_key_exists('enabled', $data) && \is_int($data['enabled'])) {
            $data['enabled'] = (bool) $data['enabled'];
        }
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('type', $data)) {
            $object->setType($this->denormalizer->denormalize($data['type'], \NoahVet\Reef\Jane\Model\PrincipalTypeEnum::class, 'json', $context));
            unset($data['type']);
        }
        if (\array_key_exists('email', $data) && null !== $data['email']) {
            $object->setEmail($data['email']);
            unset($data['email']);
        } elseif (\array_key_exists('email', $data) && null === $data['email']) {
            $object->setEmail(null);
        }
        if (\array_key_exists('lastname', $data) && null !== $data['lastname']) {
            $object->setLastname($data['lastname']);
            unset($data['lastname']);
        } elseif (\array_key_exists('lastname', $data) && null === $data['lastname']) {
            $object->setLastname(null);
        }
        if (\array_key_exists('firstname', $data) && null !== $data['firstname']) {
            $object->setFirstname($data['firstname']);
            unset($data['firstname']);
        } elseif (\array_key_exists('firstname', $data) && null === $data['firstname']) {
            $object->setFirstname(null);
        }
        if (\array_key_exists('status', $data)) {
            $object->setStatus($this->denormalizer->denormalize($data['status'], \NoahVet\Reef\Jane\Model\PrincipalStatusEnum::class, 'json', $context));
            unset($data['status']);
        }
        if (\array_key_exists('lastLogin', $data) && null !== $data['lastLogin']) {
            $object->setLastLogin(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['lastLogin']));
            unset($data['lastLogin']);
        } elseif (\array_key_exists('lastLogin', $data) && null === $data['lastLogin']) {
            $object->setLastLogin(null);
        }
        if (\array_key_exists('locale', $data) && null !== $data['locale']) {
            $object->setLocale($data['locale']);
            unset($data['locale']);
        } elseif (\array_key_exists('locale', $data) && null === $data['locale']) {
            $object->setLocale(null);
        }
        if (\array_key_exists('timezone', $data) && null !== $data['timezone']) {
            $object->setTimezone($data['timezone']);
            unset($data['timezone']);
        } elseif (\array_key_exists('timezone', $data) && null === $data['timezone']) {
            $object->setTimezone(null);
        }
        if (\array_key_exists('birthDate', $data) && null !== $data['birthDate']) {
            $object->setBirthDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['birthDate']));
            unset($data['birthDate']);
        } elseif (\array_key_exists('birthDate', $data) && null === $data['birthDate']) {
            $object->setBirthDate(null);
        }
        if (\array_key_exists('birthPostCode', $data) && null !== $data['birthPostCode']) {
            $object->setBirthPostCode($data['birthPostCode']);
            unset($data['birthPostCode']);
        } elseif (\array_key_exists('birthPostCode', $data) && null === $data['birthPostCode']) {
            $object->setBirthPostCode(null);
        }
        if (\array_key_exists('birthCity', $data) && null !== $data['birthCity']) {
            $object->setBirthCity($data['birthCity']);
            unset($data['birthCity']);
        } elseif (\array_key_exists('birthCity', $data) && null === $data['birthCity']) {
            $object->setBirthCity(null);
        }
        if (\array_key_exists('birthCountry', $data) && null !== $data['birthCountry']) {
            $value = $data['birthCountry'];
            if (\is_array($data['birthCountry'])) {
                $value = $this->denormalizer->denormalize($data['birthCountry'], \NoahVet\Reef\Jane\Model\CountryTypeEnum::class, 'json', $context);
            }
            $object->setBirthCountry($value);
            unset($data['birthCountry']);
        } elseif (\array_key_exists('birthCountry', $data) && null === $data['birthCountry']) {
            $object->setBirthCountry(null);
        }
        if (\array_key_exists('mainAddress', $data)) {
            $object->setMainAddress($this->denormalizer->denormalize($data['mainAddress'], \NoahVet\Reef\Jane\Model\PostalAddress::class, 'json', $context));
            unset($data['mainAddress']);
        }
        if (\array_key_exists('privacyPolicyAccepted', $data) && null !== $data['privacyPolicyAccepted']) {
            $object->setPrivacyPolicyAccepted(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['privacyPolicyAccepted']));
            unset($data['privacyPolicyAccepted']);
        } elseif (\array_key_exists('privacyPolicyAccepted', $data) && null === $data['privacyPolicyAccepted']) {
            $object->setPrivacyPolicyAccepted(null);
        }
        if (\array_key_exists('phoneNumbers', $data)) {
            $values = [];
            foreach ($data['phoneNumbers'] as $value_1) {
                $values_1 = [];
                foreach ($value_1 as $value_2) {
                    $values_1[] = $value_2;
                }
                $values[] = $values_1;
            }
            $object->setPhoneNumbers($values);
            unset($data['phoneNumbers']);
        }
        if (\array_key_exists('mainPhoneNumber', $data) && null !== $data['mainPhoneNumber']) {
            $object->setMainPhoneNumber($data['mainPhoneNumber']);
            unset($data['mainPhoneNumber']);
        } elseif (\array_key_exists('mainPhoneNumber', $data) && null === $data['mainPhoneNumber']) {
            $object->setMainPhoneNumber(null);
        }
        if (\array_key_exists('invitation', $data) && null !== $data['invitation']) {
            $value_3 = $data['invitation'];
            if (\is_array($data['invitation'])) {
                $value_3 = $this->denormalizer->denormalize($data['invitation'], \NoahVet\Reef\Jane\Model\PrincipalInvitation::class, 'json', $context);
            }
            $object->setInvitation($value_3);
            unset($data['invitation']);
        } elseif (\array_key_exists('invitation', $data) && null === $data['invitation']) {
            $object->setInvitation(null);
        }
        if (\array_key_exists('id', $data)) {
            $object->setId($data['id']);
            unset($data['id']);
        }
        if (\array_key_exists('created', $data)) {
            $object->setCreated(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['created']));
            unset($data['created']);
        }
        if (\array_key_exists('updated', $data)) {
            $object->setUpdated(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['updated']));
            unset($data['updated']);
        }
        if (\array_key_exists('groups', $data)) {
            $values_2 = [];
            foreach ($data['groups'] as $value_4) {
                $values_2[] = $this->denormalizer->denormalize($value_4, \NoahVet\Reef\Jane\Model\PrincipalGroup::class, 'json', $context);
            }
            $object->setGroups($values_2);
            unset($data['groups']);
        }
        if (\array_key_exists('invitationsHosted', $data)) {
            $values_3 = [];
            foreach ($data['invitationsHosted'] as $value_5) {
                $values_3[] = $this->denormalizer->denormalize($value_5, \NoahVet\Reef\Jane\Model\PrincipalInvitation::class, 'json', $context);
            }
            $object->setInvitationsHosted($values_3);
            unset($data['invitationsHosted']);
        }
        if (\array_key_exists('fullname', $data) && null !== $data['fullname']) {
            $object->setFullname($data['fullname']);
            unset($data['fullname']);
        } elseif (\array_key_exists('fullname', $data) && null === $data['fullname']) {
            $object->setFullname(null);
        }
        if (\array_key_exists('enabled', $data)) {
            $object->setEnabled($data['enabled']);
            unset($data['enabled']);
        }
        if (\array_key_exists('roles', $data)) {
            $values_4 = [];
            foreach ($data['roles'] as $value_6) {
                $values_4[] = $value_6;
            }
            $object->setRoles($values_4);
            unset($data['roles']);
        }
        if (\array_key_exists('salt', $data) && null !== $data['salt']) {
            $object->setSalt($data['salt']);
            unset($data['salt']);
        } elseif (\array_key_exists('salt', $data) && null === $data['salt']) {
            $object->setSalt(null);
        }
        if (\array_key_exists('username', $data)) {
            $object->setUsername($data['username']);
            unset($data['username']);
        }
        if (\array_key_exists('userIdentifier', $data)) {
            $object->setUserIdentifier($data['userIdentifier']);
            unset($data['userIdentifier']);
        }
        if (\array_key_exists('slug', $data)) {
            $object->setSlug($data['slug']);
            unset($data['slug']);
        }
        foreach ($data as $key => $value_7) {
            if (\preg_match('/.*/', (string) $key)) {
                $object[$key] = $value_7;
            }
        }

        return $object;
    }

    public function normalize(mixed $data, ?string $format = null, array $context = []): array|string|int|float|bool|\ArrayObject|null
    {
        $dataArray = [];
        $dataArray['type'] = $this->normalizer->normalize($data->getType(), 'json', $context);
        if ($data->isInitialized('email') && null !== $data->getEmail()) {
            $dataArray['email'] = $data->getEmail();
        }
        if ($data->isInitialized('lastname') && null !== $data->getLastname()) {
            $dataArray['lastname'] = $data->getLastname();
        }
        if ($data->isInitialized('firstname') && null !== $data->getFirstname()) {
            $dataArray['firstname'] = $data->getFirstname();
        }
        $dataArray['status'] = $this->normalizer->normalize($data->getStatus(), 'json', $context);
        if ($data->isInitialized('lastLogin') && null !== $data->getLastLogin()) {
            $dataArray['lastLogin'] = $data->getLastLogin()->format('Y-m-d\\TH:i:sP');
        }
        if ($data->isInitialized('locale') && null !== $data->getLocale()) {
            $dataArray['locale'] = $data->getLocale();
        }
        if ($data->isInitialized('timezone') && null !== $data->getTimezone()) {
            $dataArray['timezone'] = $data->getTimezone();
        }
        if ($data->isInitialized('birthDate') && null !== $data->getBirthDate()) {
            $dataArray['birthDate'] = $data->getBirthDate()->format('Y-m-d\\TH:i:sP');
        }
        if ($data->isInitialized('birthPostCode') && null !== $data->getBirthPostCode()) {
            $dataArray['birthPostCode'] = $data->getBirthPostCode();
        }
        if ($data->isInitialized('birthCity') && null !== $data->getBirthCity()) {
            $dataArray['birthCity'] = $data->getBirthCity();
        }
        if ($data->isInitialized('birthCountry') && null !== $data->getBirthCountry()) {
            $value = $data->getBirthCountry();
            if (\is_object($data->getBirthCountry())) {
                $value = $this->normalizer->normalize($data->getBirthCountry(), 'json', $context);
            }
            $dataArray['birthCountry'] = $value;
        }
        if ($data->isInitialized('mainAddress') && null !== $data->getMainAddress()) {
            $dataArray['mainAddress'] = $this->normalizer->normalize($data->getMainAddress(), 'json', $context);
        }
        if ($data->isInitialized('privacyPolicyAccepted') && null !== $data->getPrivacyPolicyAccepted()) {
            $dataArray['privacyPolicyAccepted'] = $data->getPrivacyPolicyAccepted()->format('Y-m-d\\TH:i:sP');
        }
        if ($data->isInitialized('phoneNumbers') && null !== $data->getPhoneNumbers()) {
            $values = [];
            foreach ($data->getPhoneNumbers() as $value_1) {
                $values_1 = [];
                foreach ($value_1 as $value_2) {
                    $values_1[] = $value_2;
                }
                $values[] = $values_1;
            }
            $dataArray['phoneNumbers'] = $values;
        }
        if ($data->isInitialized('mainPhoneNumber') && null !== $data->getMainPhoneNumber()) {
            $dataArray['mainPhoneNumber'] = $data->getMainPhoneNumber();
        }
        if ($data->isInitialized('invitation') && null !== $data->getInvitation()) {
            $value_3 = $data->getInvitation();
            if (\is_object($data->getInvitation())) {
                $value_3 = $this->normalizer->normalize($data->getInvitation(), 'json', $context);
            }
            $dataArray['invitation'] = $value_3;
        }
        if ($data->isInitialized('id') && null !== $data->getId()) {
            $dataArray['id'] = $data->getId();
        }
        if ($data->isInitialized('groups') && null !== $data->getGroups()) {
            $values_2 = [];
            foreach ($data->getGroups() as $value_4) {
                $values_2[] = $this->normalizer->normalize($value_4, 'json', $context);
            }
            $dataArray['groups'] = $values_2;
        }
        foreach ($data as $key => $value_5) {
            if (\preg_match('/.*/', (string) $key)) {
                $dataArray[$key] = $value_5;
            }
        }

        return $dataArray;
    }

    public function getSupportedTypes(?string $format = null): array
    {
        return [\NoahVet\Reef\Jane\Model\Principal::class => false];
    }
}
