<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Jane\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Jane\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;

class PrincipalInvitationNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use CheckArray;
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use ValidatorTrait;

    public function supportsDenormalization(mixed $data, string $type, ?string $format = null, array $context = []): bool
    {
        return \NoahVet\Reef\Jane\Model\PrincipalInvitation::class === $type;
    }

    public function supportsNormalization(mixed $data, ?string $format = null, array $context = []): bool
    {
        return \is_object($data) && \NoahVet\Reef\Jane\Model\PrincipalInvitation::class === $data::class;
    }

    public function denormalize(mixed $data, string $type, ?string $format = null, array $context = []): mixed
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Jane\Model\PrincipalInvitation();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('invited', $data)) {
            $object->setInvited($data['invited']);
            unset($data['invited']);
        }
        if (\array_key_exists('host', $data) && null !== $data['host']) {
            $object->setHost($data['host']);
            unset($data['host']);
        } elseif (\array_key_exists('host', $data) && null === $data['host']) {
            $object->setHost(null);
        }
        if (\array_key_exists('hostClient', $data) && null !== $data['hostClient']) {
            $object->setHostClient($data['hostClient']);
            unset($data['hostClient']);
        } elseif (\array_key_exists('hostClient', $data) && null === $data['hostClient']) {
            $object->setHostClient(null);
        }
        if (\array_key_exists('emailSent', $data) && null !== $data['emailSent']) {
            $object->setEmailSent(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['emailSent']));
            unset($data['emailSent']);
        } elseif (\array_key_exists('emailSent', $data) && null === $data['emailSent']) {
            $object->setEmailSent(null);
        }
        if (\array_key_exists('emailStatus', $data)) {
            $object->setEmailStatus($this->denormalizer->denormalize($data['emailStatus'], \NoahVet\Reef\Jane\Model\InvitationEmailStatusEnum::class, 'json', $context));
            unset($data['emailStatus']);
        }
        if (\array_key_exists('emailLog', $data) && null !== $data['emailLog']) {
            $object->setEmailLog($data['emailLog']);
            unset($data['emailLog']);
        } elseif (\array_key_exists('emailLog', $data) && null === $data['emailLog']) {
            $object->setEmailLog(null);
        }
        if (\array_key_exists('id', $data) && null !== $data['id']) {
            $object->setId($data['id']);
            unset($data['id']);
        } elseif (\array_key_exists('id', $data) && null === $data['id']) {
            $object->setId(null);
        }
        if (\array_key_exists('token', $data)) {
            $object->setToken($data['token']);
            unset($data['token']);
        }
        if (\array_key_exists('created', $data)) {
            $object->setCreated(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['created']));
            unset($data['created']);
        }
        if (\array_key_exists('emailTemplateNumber', $data)) {
            $object->setEmailTemplateNumber($data['emailTemplateNumber']);
            unset($data['emailTemplateNumber']);
        }
        foreach ($data as $key => $value) {
            if (\preg_match('/.*/', (string) $key)) {
                $object[$key] = $value;
            }
        }

        return $object;
    }

    public function normalize(mixed $data, ?string $format = null, array $context = []): array|string|int|float|bool|\ArrayObject|null
    {
        $dataArray = [];
        if ($data->isInitialized('invited') && null !== $data->getInvited()) {
            $dataArray['invited'] = $data->getInvited();
        }
        if ($data->isInitialized('host') && null !== $data->getHost()) {
            $dataArray['host'] = $data->getHost();
        }
        if ($data->isInitialized('hostClient') && null !== $data->getHostClient()) {
            $dataArray['hostClient'] = $data->getHostClient();
        }
        if ($data->isInitialized('emailSent') && null !== $data->getEmailSent()) {
            $dataArray['emailSent'] = $data->getEmailSent()->format('Y-m-d\\TH:i:sP');
        }
        if ($data->isInitialized('emailStatus') && null !== $data->getEmailStatus()) {
            $dataArray['emailStatus'] = $this->normalizer->normalize($data->getEmailStatus(), 'json', $context);
        }
        if ($data->isInitialized('emailLog') && null !== $data->getEmailLog()) {
            $dataArray['emailLog'] = $data->getEmailLog();
        }
        if ($data->isInitialized('emailTemplateNumber') && null !== $data->getEmailTemplateNumber()) {
            $dataArray['emailTemplateNumber'] = $data->getEmailTemplateNumber();
        }
        foreach ($data as $key => $value) {
            if (\preg_match('/.*/', (string) $key)) {
                $dataArray[$key] = $value;
            }
        }

        return $dataArray;
    }

    public function getSupportedTypes(?string $format = null): array
    {
        return [\NoahVet\Reef\Jane\Model\PrincipalInvitation::class => false];
    }
}
