<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class VeterinaryEstablishmentServiceSubscriptionRequest extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var list<VeterinaryEstablishmentServiceSubscriptionRequestAttributesItem>
     */
    protected $attributes;

    /**
     * @var \DateTime
     */
    protected $endDate;

    /**
     * @var bool
     */
    protected $isRenewal;

    /**
     * @var string
     */
    protected $paymentMethod;

    /**
     * Nullable Id - Common Request Model.
     *
     * @var NullableIdRequest|null
     */
    protected $specificBillingAccount;

    /**
     * Nullable Id - Common Request Model.
     *
     * @var NullableIdRequest|null
     */
    protected $specificVeterinaryGroup;

    /**
     * @var \DateTime
     */
    protected $startDate;

    /**
     * Id - Common Request Model.
     *
     * @var IdRequest
     */
    protected $veterinaryEstablishment;

    /**
     * Id - Common Request Model.
     *
     * @var IdRequest
     */
    protected $veterinaryServiceOption;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    /**
     * @return list<VeterinaryEstablishmentServiceSubscriptionRequestAttributesItem>
     */
    public function getAttributes(): array
    {
        return $this->attributes;
    }

    /**
     * @param list<VeterinaryEstablishmentServiceSubscriptionRequestAttributesItem> $attributes
     */
    public function setAttributes(array $attributes): self
    {
        $this->initialized['attributes'] = true;
        $this->attributes = $attributes;

        return $this;
    }

    public function getEndDate(): \DateTime
    {
        return $this->endDate;
    }

    public function setEndDate(\DateTime $endDate): self
    {
        $this->initialized['endDate'] = true;
        $this->endDate = $endDate;

        return $this;
    }

    public function getIsRenewal(): bool
    {
        return $this->isRenewal;
    }

    public function setIsRenewal(bool $isRenewal): self
    {
        $this->initialized['isRenewal'] = true;
        $this->isRenewal = $isRenewal;

        return $this;
    }

    public function getPaymentMethod(): string
    {
        return $this->paymentMethod;
    }

    public function setPaymentMethod(string $paymentMethod): self
    {
        $this->initialized['paymentMethod'] = true;
        $this->paymentMethod = $paymentMethod;

        return $this;
    }

    /**
     * Nullable Id - Common Request Model.
     */
    public function getSpecificBillingAccount(): ?NullableIdRequest
    {
        return $this->specificBillingAccount;
    }

    /**
     * Nullable Id - Common Request Model.
     */
    public function setSpecificBillingAccount(?NullableIdRequest $specificBillingAccount): self
    {
        $this->initialized['specificBillingAccount'] = true;
        $this->specificBillingAccount = $specificBillingAccount;

        return $this;
    }

    /**
     * Nullable Id - Common Request Model.
     */
    public function getSpecificVeterinaryGroup(): ?NullableIdRequest
    {
        return $this->specificVeterinaryGroup;
    }

    /**
     * Nullable Id - Common Request Model.
     */
    public function setSpecificVeterinaryGroup(?NullableIdRequest $specificVeterinaryGroup): self
    {
        $this->initialized['specificVeterinaryGroup'] = true;
        $this->specificVeterinaryGroup = $specificVeterinaryGroup;

        return $this;
    }

    public function getStartDate(): \DateTime
    {
        return $this->startDate;
    }

    public function setStartDate(\DateTime $startDate): self
    {
        $this->initialized['startDate'] = true;
        $this->startDate = $startDate;

        return $this;
    }

    /**
     * Id - Common Request Model.
     */
    public function getVeterinaryEstablishment(): IdRequest
    {
        return $this->veterinaryEstablishment;
    }

    /**
     * Id - Common Request Model.
     */
    public function setVeterinaryEstablishment(IdRequest $veterinaryEstablishment): self
    {
        $this->initialized['veterinaryEstablishment'] = true;
        $this->veterinaryEstablishment = $veterinaryEstablishment;

        return $this;
    }

    /**
     * Id - Common Request Model.
     */
    public function getVeterinaryServiceOption(): IdRequest
    {
        return $this->veterinaryServiceOption;
    }

    /**
     * Id - Common Request Model.
     */
    public function setVeterinaryServiceOption(IdRequest $veterinaryServiceOption): self
    {
        $this->initialized['veterinaryServiceOption'] = true;
        $this->veterinaryServiceOption = $veterinaryServiceOption;

        return $this;
    }
}
