<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class ServiceResource extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var string
     */
    protected $name;

    /**
     * @var string
     */
    protected $description;

    /**
     * @var string
     */
    protected $groupSlug;

    /**
     * @var array<string, ServicePermission>
     */
    protected $permissions;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getName(): string
    {
        return $this->name;
    }

    public function setName(string $name): self
    {
        $this->initialized['name'] = true;
        $this->name = $name;

        return $this;
    }

    public function getDescription(): string
    {
        return $this->description;
    }

    public function setDescription(string $description): self
    {
        $this->initialized['description'] = true;
        $this->description = $description;

        return $this;
    }

    public function getGroupSlug(): string
    {
        return $this->groupSlug;
    }

    public function setGroupSlug(string $groupSlug): self
    {
        $this->initialized['groupSlug'] = true;
        $this->groupSlug = $groupSlug;

        return $this;
    }

    /**
     * @return array<string, ServicePermission>
     */
    public function getPermissions(): iterable
    {
        return $this->permissions;
    }

    /**
     * @param array<string, ServicePermission> $permissions
     */
    public function setPermissions(iterable $permissions): self
    {
        $this->initialized['permissions'] = true;
        $this->permissions = $permissions;

        return $this;
    }
}
