<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class SchemasBillingAccountResponse extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var string
     */
    protected $id;

    /**
     * @var \DateTime
     */
    protected $createdDate;

    /**
     * @var \DateTime
     */
    protected $updatedDate;

    /**
     * @var string|null
     */
    protected $bicSwift;

    /**
     * @var string
     */
    protected $entitled;

    /**
     * Nullable Id - Response Model.
     *
     * @var NullableIdResponse|null
     */
    protected $file;

    /**
     * @var string|null
     */
    protected $iban;

    /**
     * @var string|null
     */
    protected $identityName;

    /**
     * Id - Response Model.
     *
     * @var IdResponse
     */
    protected $legalStructure;

    /**
     * @var string|null
     */
    protected $signatoryName;

    /**
     * @var string|null
     */
    protected $status;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getId(): string
    {
        return $this->id;
    }

    public function setId(string $id): self
    {
        $this->initialized['id'] = true;
        $this->id = $id;

        return $this;
    }

    public function getCreatedDate(): \DateTime
    {
        return $this->createdDate;
    }

    public function setCreatedDate(\DateTime $createdDate): self
    {
        $this->initialized['createdDate'] = true;
        $this->createdDate = $createdDate;

        return $this;
    }

    public function getUpdatedDate(): \DateTime
    {
        return $this->updatedDate;
    }

    public function setUpdatedDate(\DateTime $updatedDate): self
    {
        $this->initialized['updatedDate'] = true;
        $this->updatedDate = $updatedDate;

        return $this;
    }

    public function getBicSwift(): ?string
    {
        return $this->bicSwift;
    }

    public function setBicSwift(?string $bicSwift): self
    {
        $this->initialized['bicSwift'] = true;
        $this->bicSwift = $bicSwift;

        return $this;
    }

    public function getEntitled(): string
    {
        return $this->entitled;
    }

    public function setEntitled(string $entitled): self
    {
        $this->initialized['entitled'] = true;
        $this->entitled = $entitled;

        return $this;
    }

    /**
     * Nullable Id - Response Model.
     */
    public function getFile(): ?NullableIdResponse
    {
        return $this->file;
    }

    /**
     * Nullable Id - Response Model.
     */
    public function setFile(?NullableIdResponse $file): self
    {
        $this->initialized['file'] = true;
        $this->file = $file;

        return $this;
    }

    public function getIban(): ?string
    {
        return $this->iban;
    }

    public function setIban(?string $iban): self
    {
        $this->initialized['iban'] = true;
        $this->iban = $iban;

        return $this;
    }

    public function getIdentityName(): ?string
    {
        return $this->identityName;
    }

    public function setIdentityName(?string $identityName): self
    {
        $this->initialized['identityName'] = true;
        $this->identityName = $identityName;

        return $this;
    }

    /**
     * Id - Response Model.
     */
    public function getLegalStructure(): IdResponse
    {
        return $this->legalStructure;
    }

    /**
     * Id - Response Model.
     */
    public function setLegalStructure(IdResponse $legalStructure): self
    {
        $this->initialized['legalStructure'] = true;
        $this->legalStructure = $legalStructure;

        return $this;
    }

    public function getSignatoryName(): ?string
    {
        return $this->signatoryName;
    }

    public function setSignatoryName(?string $signatoryName): self
    {
        $this->initialized['signatoryName'] = true;
        $this->signatoryName = $signatoryName;

        return $this;
    }

    public function getStatus(): ?string
    {
        return $this->status;
    }

    public function setStatus(?string $status): self
    {
        $this->initialized['status'] = true;
        $this->status = $status;

        return $this;
    }
}
