<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class ProductPriceResponseItemCovetoProduct extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var string|null
     */
    protected $code;

    /**
     * @var string|null
     */
    protected $netPrice;

    /**
     * @var string|null
     */
    protected $price;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getCode(): ?string
    {
        return $this->code;
    }

    public function setCode(?string $code): self
    {
        $this->initialized['code'] = true;
        $this->code = $code;

        return $this;
    }

    public function getNetPrice(): ?string
    {
        return $this->netPrice;
    }

    public function setNetPrice(?string $netPrice): self
    {
        $this->initialized['netPrice'] = true;
        $this->netPrice = $netPrice;

        return $this;
    }

    public function getPrice(): ?string
    {
        return $this->price;
    }

    public function setPrice(?string $price): self
    {
        $this->initialized['price'] = true;
        $this->price = $price;

        return $this;
    }
}
