<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class PrincipalGroup extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var string
     */
    protected $friendlyName;

    /**
     * @var string
     */
    protected $slug;

    /**
     * @var string|null
     */
    protected $description;

    /**
     * @var list<string>
     */
    protected $principals;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getFriendlyName(): string
    {
        return $this->friendlyName;
    }

    public function setFriendlyName(string $friendlyName): self
    {
        $this->initialized['friendlyName'] = true;
        $this->friendlyName = $friendlyName;

        return $this;
    }

    public function getSlug(): string
    {
        return $this->slug;
    }

    public function setSlug(string $slug): self
    {
        $this->initialized['slug'] = true;
        $this->slug = $slug;

        return $this;
    }

    public function getDescription(): ?string
    {
        return $this->description;
    }

    public function setDescription(?string $description): self
    {
        $this->initialized['description'] = true;
        $this->description = $description;

        return $this;
    }

    /**
     * @return list<string>
     */
    public function getPrincipals(): array
    {
        return $this->principals;
    }

    /**
     * @param list<string> $principals
     */
    public function setPrincipals(array $principals): self
    {
        $this->initialized['principals'] = true;
        $this->principals = $principals;

        return $this;
    }
}
