<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class PolicyResultPolicyResultPost extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var string
     */
    protected $name;

    /**
     * @var string
     */
    protected $subject;

    /**
     * @var string
     */
    protected $etag;

    /**
     * @var list<GrantedPermissionShort>
     */
    protected $grants;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getName(): string
    {
        return $this->name;
    }

    public function setName(string $name): self
    {
        $this->initialized['name'] = true;
        $this->name = $name;

        return $this;
    }

    public function getSubject(): string
    {
        return $this->subject;
    }

    public function setSubject(string $subject): self
    {
        $this->initialized['subject'] = true;
        $this->subject = $subject;

        return $this;
    }

    public function getEtag(): string
    {
        return $this->etag;
    }

    public function setEtag(string $etag): self
    {
        $this->initialized['etag'] = true;
        $this->etag = $etag;

        return $this;
    }

    /**
     * @return list<GrantedPermissionShort>
     */
    public function getGrants(): array
    {
        return $this->grants;
    }

    /**
     * @param list<GrantedPermissionShort> $grants
     */
    public function setGrants(array $grants): self
    {
        $this->initialized['grants'] = true;
        $this->grants = $grants;

        return $this;
    }
}
