<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class OpeningPeriodResponse extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var OpeningHourResponse
     */
    protected $start;

    /**
     * @var OpeningHourResponse
     */
    protected $end;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getStart(): OpeningHourResponse
    {
        return $this->start;
    }

    public function setStart(OpeningHourResponse $start): self
    {
        $this->initialized['start'] = true;
        $this->start = $start;

        return $this;
    }

    public function getEnd(): OpeningHourResponse
    {
        return $this->end;
    }

    public function setEnd(OpeningHourResponse $end): self
    {
        $this->initialized['end'] = true;
        $this->end = $end;

        return $this;
    }
}
