<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class CreditNoteResponseCreditNoteLinesItem extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var string
     */
    protected $id;

    /**
     * @var string
     */
    protected $accountingCode;

    /**
     * @var int
     */
    protected $amountWithoutVat;

    /**
     * @var int
     */
    protected $amountWithVat;

    /**
     * @var string
     */
    protected $analyticCode;

    /**
     * Depending on the category chosen, the amount will automatically be entered as positive or negative in the calculation.
     *
     * @var string
     */
    protected $category;

    /**
     * @var string
     */
    protected $code;

    /**
     * @var string
     */
    protected $entitled;

    /**
     * @var string|null
     */
    protected $longDescription;

    /**
     * @var string
     */
    protected $vatCategory;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getId(): string
    {
        return $this->id;
    }

    public function setId(string $id): self
    {
        $this->initialized['id'] = true;
        $this->id = $id;

        return $this;
    }

    public function getAccountingCode(): string
    {
        return $this->accountingCode;
    }

    public function setAccountingCode(string $accountingCode): self
    {
        $this->initialized['accountingCode'] = true;
        $this->accountingCode = $accountingCode;

        return $this;
    }

    public function getAmountWithoutVat(): int
    {
        return $this->amountWithoutVat;
    }

    public function setAmountWithoutVat(int $amountWithoutVat): self
    {
        $this->initialized['amountWithoutVat'] = true;
        $this->amountWithoutVat = $amountWithoutVat;

        return $this;
    }

    public function getAmountWithVat(): int
    {
        return $this->amountWithVat;
    }

    public function setAmountWithVat(int $amountWithVat): self
    {
        $this->initialized['amountWithVat'] = true;
        $this->amountWithVat = $amountWithVat;

        return $this;
    }

    public function getAnalyticCode(): string
    {
        return $this->analyticCode;
    }

    public function setAnalyticCode(string $analyticCode): self
    {
        $this->initialized['analyticCode'] = true;
        $this->analyticCode = $analyticCode;

        return $this;
    }

    /**
     * Depending on the category chosen, the amount will automatically be entered as positive or negative in the calculation.
     */
    public function getCategory(): string
    {
        return $this->category;
    }

    /**
     * Depending on the category chosen, the amount will automatically be entered as positive or negative in the calculation.
     */
    public function setCategory(string $category): self
    {
        $this->initialized['category'] = true;
        $this->category = $category;

        return $this;
    }

    public function getCode(): string
    {
        return $this->code;
    }

    public function setCode(string $code): self
    {
        $this->initialized['code'] = true;
        $this->code = $code;

        return $this;
    }

    public function getEntitled(): string
    {
        return $this->entitled;
    }

    public function setEntitled(string $entitled): self
    {
        $this->initialized['entitled'] = true;
        $this->entitled = $entitled;

        return $this;
    }

    public function getLongDescription(): ?string
    {
        return $this->longDescription;
    }

    public function setLongDescription(?string $longDescription): self
    {
        $this->initialized['longDescription'] = true;
        $this->longDescription = $longDescription;

        return $this;
    }

    public function getVatCategory(): string
    {
        return $this->vatCategory;
    }

    public function setVatCategory(string $vatCategory): self
    {
        $this->initialized['vatCategory'] = true;
        $this->vatCategory = $vatCategory;

        return $this;
    }
}
