<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class CreditNoteResponse extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var string
     */
    protected $id;

    /**
     * @var \DateTime
     */
    protected $createdDate;

    /**
     * @var \DateTime
     */
    protected $updatedDate;

    /**
     * @var string
     */
    protected $accountingCode;

    /**
     * @var CreditNoteResponseAccountingMovement
     */
    protected $accountingMovement;

    /**
     * @var int
     */
    protected $amountWithoutVat;

    /**
     * @var int
     */
    protected $amountWithVat;

    /**
     * @var CreditNoteResponseBankAccount
     */
    protected $bankAccount;

    /**
     * Credit Note Category.
     *
     * @var string
     */
    protected $category;

    /**
     * @var list<CreditNoteResponseCreditNoteLinesItem>
     */
    protected $creditNoteLines;

    /**
     * @var InvoiceAddressResponse
     */
    protected $deliveryAddress;

    /**
     * @var InvoiceInformationResponse
     */
    protected $deliveryInformation;

    /**
     * @var string
     */
    protected $entitled;

    /**
     * @var string
     */
    protected $paymentMethod;

    /**
     * @var string
     */
    protected $paymentStatus;

    /**
     * @var string|null
     */
    protected $personalisedMention;

    /**
     * Id - Response Model.
     *
     * @var IdResponse
     */
    protected $pdfDocument;

    /**
     * @var InvoiceAddressResponse
     */
    protected $receiverAddress;

    /**
     * @var InvoiceInformationResponse
     */
    protected $receiverInformation;

    /**
     * @var InvoiceAddressResponse
     */
    protected $senderAddress;

    /**
     * @var InvoiceInformationResponse
     */
    protected $senderInformation;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getId(): string
    {
        return $this->id;
    }

    public function setId(string $id): self
    {
        $this->initialized['id'] = true;
        $this->id = $id;

        return $this;
    }

    public function getCreatedDate(): \DateTime
    {
        return $this->createdDate;
    }

    public function setCreatedDate(\DateTime $createdDate): self
    {
        $this->initialized['createdDate'] = true;
        $this->createdDate = $createdDate;

        return $this;
    }

    public function getUpdatedDate(): \DateTime
    {
        return $this->updatedDate;
    }

    public function setUpdatedDate(\DateTime $updatedDate): self
    {
        $this->initialized['updatedDate'] = true;
        $this->updatedDate = $updatedDate;

        return $this;
    }

    public function getAccountingCode(): string
    {
        return $this->accountingCode;
    }

    public function setAccountingCode(string $accountingCode): self
    {
        $this->initialized['accountingCode'] = true;
        $this->accountingCode = $accountingCode;

        return $this;
    }

    public function getAccountingMovement(): CreditNoteResponseAccountingMovement
    {
        return $this->accountingMovement;
    }

    public function setAccountingMovement(CreditNoteResponseAccountingMovement $accountingMovement): self
    {
        $this->initialized['accountingMovement'] = true;
        $this->accountingMovement = $accountingMovement;

        return $this;
    }

    public function getAmountWithoutVat(): int
    {
        return $this->amountWithoutVat;
    }

    public function setAmountWithoutVat(int $amountWithoutVat): self
    {
        $this->initialized['amountWithoutVat'] = true;
        $this->amountWithoutVat = $amountWithoutVat;

        return $this;
    }

    public function getAmountWithVat(): int
    {
        return $this->amountWithVat;
    }

    public function setAmountWithVat(int $amountWithVat): self
    {
        $this->initialized['amountWithVat'] = true;
        $this->amountWithVat = $amountWithVat;

        return $this;
    }

    public function getBankAccount(): CreditNoteResponseBankAccount
    {
        return $this->bankAccount;
    }

    public function setBankAccount(CreditNoteResponseBankAccount $bankAccount): self
    {
        $this->initialized['bankAccount'] = true;
        $this->bankAccount = $bankAccount;

        return $this;
    }

    /**
     * Credit Note Category.
     */
    public function getCategory(): string
    {
        return $this->category;
    }

    /**
     * Credit Note Category.
     */
    public function setCategory(string $category): self
    {
        $this->initialized['category'] = true;
        $this->category = $category;

        return $this;
    }

    /**
     * @return list<CreditNoteResponseCreditNoteLinesItem>
     */
    public function getCreditNoteLines(): array
    {
        return $this->creditNoteLines;
    }

    /**
     * @param list<CreditNoteResponseCreditNoteLinesItem> $creditNoteLines
     */
    public function setCreditNoteLines(array $creditNoteLines): self
    {
        $this->initialized['creditNoteLines'] = true;
        $this->creditNoteLines = $creditNoteLines;

        return $this;
    }

    public function getDeliveryAddress(): InvoiceAddressResponse
    {
        return $this->deliveryAddress;
    }

    public function setDeliveryAddress(InvoiceAddressResponse $deliveryAddress): self
    {
        $this->initialized['deliveryAddress'] = true;
        $this->deliveryAddress = $deliveryAddress;

        return $this;
    }

    public function getDeliveryInformation(): InvoiceInformationResponse
    {
        return $this->deliveryInformation;
    }

    public function setDeliveryInformation(InvoiceInformationResponse $deliveryInformation): self
    {
        $this->initialized['deliveryInformation'] = true;
        $this->deliveryInformation = $deliveryInformation;

        return $this;
    }

    public function getEntitled(): string
    {
        return $this->entitled;
    }

    public function setEntitled(string $entitled): self
    {
        $this->initialized['entitled'] = true;
        $this->entitled = $entitled;

        return $this;
    }

    public function getPaymentMethod(): string
    {
        return $this->paymentMethod;
    }

    public function setPaymentMethod(string $paymentMethod): self
    {
        $this->initialized['paymentMethod'] = true;
        $this->paymentMethod = $paymentMethod;

        return $this;
    }

    public function getPaymentStatus(): string
    {
        return $this->paymentStatus;
    }

    public function setPaymentStatus(string $paymentStatus): self
    {
        $this->initialized['paymentStatus'] = true;
        $this->paymentStatus = $paymentStatus;

        return $this;
    }

    public function getPersonalisedMention(): ?string
    {
        return $this->personalisedMention;
    }

    public function setPersonalisedMention(?string $personalisedMention): self
    {
        $this->initialized['personalisedMention'] = true;
        $this->personalisedMention = $personalisedMention;

        return $this;
    }

    /**
     * Id - Response Model.
     */
    public function getPdfDocument(): IdResponse
    {
        return $this->pdfDocument;
    }

    /**
     * Id - Response Model.
     */
    public function setPdfDocument(IdResponse $pdfDocument): self
    {
        $this->initialized['pdfDocument'] = true;
        $this->pdfDocument = $pdfDocument;

        return $this;
    }

    public function getReceiverAddress(): InvoiceAddressResponse
    {
        return $this->receiverAddress;
    }

    public function setReceiverAddress(InvoiceAddressResponse $receiverAddress): self
    {
        $this->initialized['receiverAddress'] = true;
        $this->receiverAddress = $receiverAddress;

        return $this;
    }

    public function getReceiverInformation(): InvoiceInformationResponse
    {
        return $this->receiverInformation;
    }

    public function setReceiverInformation(InvoiceInformationResponse $receiverInformation): self
    {
        $this->initialized['receiverInformation'] = true;
        $this->receiverInformation = $receiverInformation;

        return $this;
    }

    public function getSenderAddress(): InvoiceAddressResponse
    {
        return $this->senderAddress;
    }

    public function setSenderAddress(InvoiceAddressResponse $senderAddress): self
    {
        $this->initialized['senderAddress'] = true;
        $this->senderAddress = $senderAddress;

        return $this;
    }

    public function getSenderInformation(): InvoiceInformationResponse
    {
        return $this->senderInformation;
    }

    public function setSenderInformation(InvoiceInformationResponse $senderInformation): self
    {
        $this->initialized['senderInformation'] = true;
        $this->senderInformation = $senderInformation;

        return $this;
    }
}
