<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class CreditNoteBankTransferRequest extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * Credit Note Category.
     *
     * @var string
     */
    protected $category;

    /**
     * @var string
     */
    protected $code;

    /**
     * Id - Common Request Model.
     *
     * @var IdRequest
     */
    protected $fromCreditNote;

    /**
     * Id - Common Request Model.
     *
     * @var IdRequest
     */
    protected $toCreditNote;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    /**
     * Credit Note Category.
     */
    public function getCategory(): string
    {
        return $this->category;
    }

    /**
     * Credit Note Category.
     */
    public function setCategory(string $category): self
    {
        $this->initialized['category'] = true;
        $this->category = $category;

        return $this;
    }

    public function getCode(): string
    {
        return $this->code;
    }

    public function setCode(string $code): self
    {
        $this->initialized['code'] = true;
        $this->code = $code;

        return $this;
    }

    /**
     * Id - Common Request Model.
     */
    public function getFromCreditNote(): IdRequest
    {
        return $this->fromCreditNote;
    }

    /**
     * Id - Common Request Model.
     */
    public function setFromCreditNote(IdRequest $fromCreditNote): self
    {
        $this->initialized['fromCreditNote'] = true;
        $this->fromCreditNote = $fromCreditNote;

        return $this;
    }

    /**
     * Id - Common Request Model.
     */
    public function getToCreditNote(): IdRequest
    {
        return $this->toCreditNote;
    }

    /**
     * Id - Common Request Model.
     */
    public function setToCreditNote(IdRequest $toCreditNote): self
    {
        $this->initialized['toCreditNote'] = true;
        $this->toCreditNote = $toCreditNote;

        return $this;
    }
}
