<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class ContractResponse extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var string
     */
    protected $id;

    /**
     * @var \DateTime
     */
    protected $createdDate;

    /**
     * @var \DateTime
     */
    protected $updatedDate;

    /**
     * @var list<IdResponse>
     */
    protected $contractDocuments;

    /**
     * @var list<IdResponse>
     */
    protected $veterinaryEstablishmentServiceSubscriptions;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getId(): string
    {
        return $this->id;
    }

    public function setId(string $id): self
    {
        $this->initialized['id'] = true;
        $this->id = $id;

        return $this;
    }

    public function getCreatedDate(): \DateTime
    {
        return $this->createdDate;
    }

    public function setCreatedDate(\DateTime $createdDate): self
    {
        $this->initialized['createdDate'] = true;
        $this->createdDate = $createdDate;

        return $this;
    }

    public function getUpdatedDate(): \DateTime
    {
        return $this->updatedDate;
    }

    public function setUpdatedDate(\DateTime $updatedDate): self
    {
        $this->initialized['updatedDate'] = true;
        $this->updatedDate = $updatedDate;

        return $this;
    }

    /**
     * @return list<IdResponse>
     */
    public function getContractDocuments(): array
    {
        return $this->contractDocuments;
    }

    /**
     * @param list<IdResponse> $contractDocuments
     */
    public function setContractDocuments(array $contractDocuments): self
    {
        $this->initialized['contractDocuments'] = true;
        $this->contractDocuments = $contractDocuments;

        return $this;
    }

    /**
     * @return list<IdResponse>
     */
    public function getVeterinaryEstablishmentServiceSubscriptions(): array
    {
        return $this->veterinaryEstablishmentServiceSubscriptions;
    }

    /**
     * @param list<IdResponse> $veterinaryEstablishmentServiceSubscriptions
     */
    public function setVeterinaryEstablishmentServiceSubscriptions(array $veterinaryEstablishmentServiceSubscriptions): self
    {
        $this->initialized['veterinaryEstablishmentServiceSubscriptions'] = true;
        $this->veterinaryEstablishmentServiceSubscriptions = $veterinaryEstablishmentServiceSubscriptions;

        return $this;
    }
}
