<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Endpoint;

class GetResourceItem extends \NoahVet\Reef\Jane\Runtime\Client\BaseEndpoint implements \NoahVet\Reef\Jane\Runtime\Client\Endpoint
{
    use \NoahVet\Reef\Jane\Runtime\Client\EndpointTrait;

    protected $slug;

    protected $accept;

    /**
     * Retrieves a Resource resource.
     *
     * @param string $slug   Resource identifier
     * @param array  $accept Accept content header application/json|text/html
     */
    public function __construct(string $slug, array $accept = [])
    {
        $this->slug = $slug;
        $this->accept = $accept;
    }

    public function getMethod(): string
    {
        return 'GET';
    }

    public function getUri(): string
    {
        return \str_replace(['{slug}'], [$this->slug], '/api/resources/{slug}');
    }

    public function getBody(\Symfony\Component\Serializer\SerializerInterface $serializer, $streamFactory = null): array
    {
        return [[], null];
    }

    public function getExtraHeaders(): array
    {
        return ['Accept' => ['application/json']];
    }

    public function getAuthenticationScopes(): array
    {
        return ['BearerAuth'];
    }

    /**
     * @return \NoahVet\Reef\Jane\Model\Resource
     *
     * @throws \NoahVet\Reef\Jane\Exception\GetResourceItemNotFoundException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    protected function transformResponseBody(\Psr\Http\Message\ResponseInterface $response, \Symfony\Component\Serializer\SerializerInterface $serializer, ?string $contentType = null)
    {
        $status = $response->getStatusCode();
        $body = (string) $response->getBody();
        if ((null === $contentType) === false && (200 === $status && false !== \mb_strpos($contentType, 'application/json'))) {
            return $serializer->deserialize($body, 'NoahVet\\Reef\\Jane\\Model\\Resource', 'json');
        }
        if (404 === $status) {
            throw new \NoahVet\Reef\Jane\Exception\GetResourceItemNotFoundException($response);
        }
        throw new \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException($status, $body);
    }
}
