<?php

declare(strict_types=1);

namespace NoahVet\Reef\Iterator\Factory;

use NoahVet\Reef\Iterator\ReefApiIteratorInterface;
use NoahVet\Reef\Jane\Normalizer\JaneObjectNormalizer;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;

interface ReefApiIteratorFactoryInterface
{
    /**
     * @template TEndpoint of object
     * @template TValue of object
     *
     * @param class-string<TEndpoint> $endpoint
     * @param class-string<TValue>    $responseClass
     * @param array<string, mixed>    $params
     *
     * @return ReefApiIteratorInterface<TValue, array<string, mixed>>
     */
    public function create(
        object $client,
        string $endpoint,
        string $responseClass,
        array $params = [],
        int $querySize = 50,
        ?string $chunkProperty = null,
        NormalizerInterface $responseNormalizer = new JaneObjectNormalizer(),
    ): ReefApiIteratorInterface;
}
